<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Worker_Role_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Project Worker Role data
 * @subpackage Structs
 */
class Project_Worker_Role_DataType extends AbstractStructBase
{
    /**
     * The Project_Worker_Role_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Worker Role ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Worker_Role_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Restricted_to_Project_Hierarchies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restricted to Project Hierarchies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType[]
     */
    public $Restricted_to_Project_Hierarchies_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive Project Role
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Project_Resource_Requirement_Parameter_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Requirement Parameter Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Resource_Requirement_Parameter_DataType[]
     */
    public $Project_Resource_Requirement_Parameter_Data;
    /**
     * Constructor method for Project_Worker_Role_DataType
     * @uses Project_Worker_Role_DataType::setProject_Worker_Role_ID()
     * @uses Project_Worker_Role_DataType::setName()
     * @uses Project_Worker_Role_DataType::setDescription()
     * @uses Project_Worker_Role_DataType::setRestricted_to_Project_Hierarchies_Reference()
     * @uses Project_Worker_Role_DataType::setInactive()
     * @uses Project_Worker_Role_DataType::setProject_Resource_Requirement_Parameter_Data()
     * @param string $project_Worker_Role_ID
     * @param string $name
     * @param string $description
     * @param \StructType\Project_HierarchyObjectType[] $restricted_to_Project_Hierarchies_Reference
     * @param bool $inactive
     * @param \StructType\Project_Resource_Requirement_Parameter_DataType[] $project_Resource_Requirement_Parameter_Data
     */
    public function __construct($project_Worker_Role_ID = null, $name = null, $description = null, array $restricted_to_Project_Hierarchies_Reference = array(), $inactive = null, array $project_Resource_Requirement_Parameter_Data = array())
    {
        $this
            ->setProject_Worker_Role_ID($project_Worker_Role_ID)
            ->setName($name)
            ->setDescription($description)
            ->setRestricted_to_Project_Hierarchies_Reference($restricted_to_Project_Hierarchies_Reference)
            ->setInactive($inactive)
            ->setProject_Resource_Requirement_Parameter_Data($project_Resource_Requirement_Parameter_Data);
    }
    /**
     * Get Project_Worker_Role_ID value
     * @return string|null
     */
    public function getProject_Worker_Role_ID()
    {
        return $this->Project_Worker_Role_ID;
    }
    /**
     * Set Project_Worker_Role_ID value
     * @param string $project_Worker_Role_ID
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setProject_Worker_Role_ID($project_Worker_Role_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Worker_Role_ID) && !is_string($project_Worker_Role_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Worker_Role_ID, true), gettype($project_Worker_Role_ID)), __LINE__);
        }
        $this->Project_Worker_Role_ID = $project_Worker_Role_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Restricted_to_Project_Hierarchies_Reference value
     * @return \StructType\Project_HierarchyObjectType[]|null
     */
    public function getRestricted_to_Project_Hierarchies_Reference()
    {
        return $this->Restricted_to_Project_Hierarchies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Project_Hierarchies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Project_Hierarchies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Project_Hierarchies_ReferenceForArrayConstraintsFromSetRestricted_to_Project_Hierarchies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem instanceof \StructType\Project_HierarchyObjectType) {
                $invalidValues[] = is_object($project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) ? get_class($project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem) : sprintf('%s(%s)', gettype($project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem), var_export($project_Worker_Role_DataTypeRestricted_to_Project_Hierarchies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType[] $restricted_to_Project_Hierarchies_Reference
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setRestricted_to_Project_Hierarchies_Reference(array $restricted_to_Project_Hierarchies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Project_Hierarchies_ReferenceArrayErrorMessage = self::validateRestricted_to_Project_Hierarchies_ReferenceForArrayConstraintsFromSetRestricted_to_Project_Hierarchies_Reference($restricted_to_Project_Hierarchies_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Project_Hierarchies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Project_Hierarchies_Reference = $restricted_to_Project_Hierarchies_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType $item
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function addToRestricted_to_Project_Hierarchies_Reference(\StructType\Project_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Project_Hierarchies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Project_Resource_Requirement_Parameter_Data value
     * @return \StructType\Project_Resource_Requirement_Parameter_DataType[]|null
     */
    public function getProject_Resource_Requirement_Parameter_Data()
    {
        return $this->Project_Resource_Requirement_Parameter_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Resource_Requirement_Parameter_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Resource_Requirement_Parameter_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Resource_Requirement_Parameter_DataForArrayConstraintsFromSetProject_Resource_Requirement_Parameter_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem) {
            // validation for constraint: itemType
            if (!$project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem instanceof \StructType\Project_Resource_Requirement_Parameter_DataType) {
                $invalidValues[] = is_object($project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem) ? get_class($project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem) : sprintf('%s(%s)', gettype($project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem), var_export($project_Worker_Role_DataTypeProject_Resource_Requirement_Parameter_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Resource_Requirement_Parameter_Data property can only contain items of type \StructType\Project_Resource_Requirement_Parameter_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Resource_Requirement_Parameter_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Resource_Requirement_Parameter_DataType[] $project_Resource_Requirement_Parameter_Data
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function setProject_Resource_Requirement_Parameter_Data(array $project_Resource_Requirement_Parameter_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Resource_Requirement_Parameter_DataArrayErrorMessage = self::validateProject_Resource_Requirement_Parameter_DataForArrayConstraintsFromSetProject_Resource_Requirement_Parameter_Data($project_Resource_Requirement_Parameter_Data))) {
            throw new \InvalidArgumentException($project_Resource_Requirement_Parameter_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Resource_Requirement_Parameter_Data = $project_Resource_Requirement_Parameter_Data;
        return $this;
    }
    /**
     * Add item to Project_Resource_Requirement_Parameter_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Resource_Requirement_Parameter_DataType $item
     * @return \StructType\Project_Worker_Role_DataType
     */
    public function addToProject_Resource_Requirement_Parameter_Data(\StructType\Project_Resource_Requirement_Parameter_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Resource_Requirement_Parameter_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Resource_Requirement_Parameter_Data property can only contain items of type \StructType\Project_Resource_Requirement_Parameter_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Resource_Requirement_Parameter_Data[] = $item;
        return $this;
    }
}
