<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_TaskType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Project Task Instance and Data
 * @subpackage Structs
 */
class Project_TaskType extends AbstractStructBase
{
    /**
     * The Project_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Task
     * - minOccurs: 0
     * @var \StructType\Project_TaskObjectType
     */
    public $Project_Task_Reference;
    /**
     * The Project_Task_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Project Task data to be retrieved or input via web service
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Task_DataType[]
     */
    public $Project_Task_Data;
    /**
     * Constructor method for Project_TaskType
     * @uses Project_TaskType::setProject_Task_Reference()
     * @uses Project_TaskType::setProject_Task_Data()
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @param \StructType\Project_Task_DataType[] $project_Task_Data
     */
    public function __construct(\StructType\Project_TaskObjectType $project_Task_Reference = null, array $project_Task_Data = array())
    {
        $this
            ->setProject_Task_Reference($project_Task_Reference)
            ->setProject_Task_Data($project_Task_Data);
    }
    /**
     * Get Project_Task_Reference value
     * @return \StructType\Project_TaskObjectType|null
     */
    public function getProject_Task_Reference()
    {
        return $this->Project_Task_Reference;
    }
    /**
     * Set Project_Task_Reference value
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @return \StructType\Project_TaskType
     */
    public function setProject_Task_Reference(\StructType\Project_TaskObjectType $project_Task_Reference = null)
    {
        $this->Project_Task_Reference = $project_Task_Reference;
        return $this;
    }
    /**
     * Get Project_Task_Data value
     * @return \StructType\Project_Task_DataType[]|null
     */
    public function getProject_Task_Data()
    {
        return $this->Project_Task_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Task_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Task_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Task_DataForArrayConstraintsFromSetProject_Task_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_TaskTypeProject_Task_DataItem) {
            // validation for constraint: itemType
            if (!$project_TaskTypeProject_Task_DataItem instanceof \StructType\Project_Task_DataType) {
                $invalidValues[] = is_object($project_TaskTypeProject_Task_DataItem) ? get_class($project_TaskTypeProject_Task_DataItem) : sprintf('%s(%s)', gettype($project_TaskTypeProject_Task_DataItem), var_export($project_TaskTypeProject_Task_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Task_Data property can only contain items of type \StructType\Project_Task_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Task_DataType[] $project_Task_Data
     * @return \StructType\Project_TaskType
     */
    public function setProject_Task_Data(array $project_Task_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Task_DataArrayErrorMessage = self::validateProject_Task_DataForArrayConstraintsFromSetProject_Task_Data($project_Task_Data))) {
            throw new \InvalidArgumentException($project_Task_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Task_Data = $project_Task_Data;
        return $this;
    }
    /**
     * Add item to Project_Task_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Task_DataType $item
     * @return \StructType\Project_TaskType
     */
    public function addToProject_Task_Data(\StructType\Project_Task_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Task_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Task_Data property can only contain items of type \StructType\Project_Task_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Task_Data[] = $item;
        return $this;
    }
}
