<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Spend Data instances of the same Data Value and Attribute Type is not allowed. | Element that contains Hotel Data
 * @subpackage Structs
 */
class Hotel_DataType extends AbstractStructBase
{
    /**
     * The Spend_Data_ID
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Data_ID;
    /**
     * The Hotel_Value
     * Meta information extracted from the WSDL
     * - documentation: Hotel Value
     * - maxOccurs: 1
     * @var string
     */
    public $Hotel_Value;
    /**
     * The Merchant_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Each Merchant Code can only be assigned to one Merchant (Airline, Hotel, or Car Rental Agency). | A Merchant Code to map to this Hotel. If a Merchant Code is specified, it will be used on Expense Credit Card Transactions to match the
     * specified Merchant Code to this Hotel.
     * - minOccurs: 0
     * @var \StructType\Merchant_CodeObjectType
     */
    public $Merchant_Code_Reference;
    /**
     * The Alternate_Merchant_Name_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Merchant_Name_DataType[]
     */
    public $Alternate_Merchant_Name_Data;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: By default, Workday sets Hotel to active. A Hotel with a value of 1 changes to inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Hotel_DataType
     * @uses Hotel_DataType::setSpend_Data_ID()
     * @uses Hotel_DataType::setHotel_Value()
     * @uses Hotel_DataType::setMerchant_Code_Reference()
     * @uses Hotel_DataType::setAlternate_Merchant_Name_Data()
     * @uses Hotel_DataType::setInactive()
     * @param string $spend_Data_ID
     * @param string $hotel_Value
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @param \StructType\Alternate_Merchant_Name_DataType[] $alternate_Merchant_Name_Data
     * @param bool $inactive
     */
    public function __construct($spend_Data_ID = null, $hotel_Value = null, \StructType\Merchant_CodeObjectType $merchant_Code_Reference = null, array $alternate_Merchant_Name_Data = array(), $inactive = null)
    {
        $this
            ->setSpend_Data_ID($spend_Data_ID)
            ->setHotel_Value($hotel_Value)
            ->setMerchant_Code_Reference($merchant_Code_Reference)
            ->setAlternate_Merchant_Name_Data($alternate_Merchant_Name_Data)
            ->setInactive($inactive);
    }
    /**
     * Get Spend_Data_ID value
     * @return string|null
     */
    public function getSpend_Data_ID()
    {
        return $this->Spend_Data_ID;
    }
    /**
     * Set Spend_Data_ID value
     * @param string $spend_Data_ID
     * @return \StructType\Hotel_DataType
     */
    public function setSpend_Data_ID($spend_Data_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Data_ID) && !is_string($spend_Data_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Data_ID, true), gettype($spend_Data_ID)), __LINE__);
        }
        $this->Spend_Data_ID = $spend_Data_ID;
        return $this;
    }
    /**
     * Get Hotel_Value value
     * @return string|null
     */
    public function getHotel_Value()
    {
        return $this->Hotel_Value;
    }
    /**
     * Set Hotel_Value value
     * @param string $hotel_Value
     * @return \StructType\Hotel_DataType
     */
    public function setHotel_Value($hotel_Value = null)
    {
        // validation for constraint: string
        if (!is_null($hotel_Value) && !is_string($hotel_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel_Value, true), gettype($hotel_Value)), __LINE__);
        }
        $this->Hotel_Value = $hotel_Value;
        return $this;
    }
    /**
     * Get Merchant_Code_Reference value
     * @return \StructType\Merchant_CodeObjectType|null
     */
    public function getMerchant_Code_Reference()
    {
        return $this->Merchant_Code_Reference;
    }
    /**
     * Set Merchant_Code_Reference value
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @return \StructType\Hotel_DataType
     */
    public function setMerchant_Code_Reference(\StructType\Merchant_CodeObjectType $merchant_Code_Reference = null)
    {
        $this->Merchant_Code_Reference = $merchant_Code_Reference;
        return $this;
    }
    /**
     * Get Alternate_Merchant_Name_Data value
     * @return \StructType\Alternate_Merchant_Name_DataType[]|null
     */
    public function getAlternate_Merchant_Name_Data()
    {
        return $this->Alternate_Merchant_Name_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Merchant_Name_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Merchant_Name_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Merchant_Name_DataForArrayConstraintsFromSetAlternate_Merchant_Name_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotel_DataTypeAlternate_Merchant_Name_DataItem) {
            // validation for constraint: itemType
            if (!$hotel_DataTypeAlternate_Merchant_Name_DataItem instanceof \StructType\Alternate_Merchant_Name_DataType) {
                $invalidValues[] = is_object($hotel_DataTypeAlternate_Merchant_Name_DataItem) ? get_class($hotel_DataTypeAlternate_Merchant_Name_DataItem) : sprintf('%s(%s)', gettype($hotel_DataTypeAlternate_Merchant_Name_DataItem), var_export($hotel_DataTypeAlternate_Merchant_Name_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Merchant_Name_Data property can only contain items of type \StructType\Alternate_Merchant_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Merchant_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Merchant_Name_DataType[] $alternate_Merchant_Name_Data
     * @return \StructType\Hotel_DataType
     */
    public function setAlternate_Merchant_Name_Data(array $alternate_Merchant_Name_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Merchant_Name_DataArrayErrorMessage = self::validateAlternate_Merchant_Name_DataForArrayConstraintsFromSetAlternate_Merchant_Name_Data($alternate_Merchant_Name_Data))) {
            throw new \InvalidArgumentException($alternate_Merchant_Name_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Merchant_Name_Data = $alternate_Merchant_Name_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Merchant_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Merchant_Name_DataType $item
     * @return \StructType\Hotel_DataType
     */
    public function addToAlternate_Merchant_Name_Data(\StructType\Alternate_Merchant_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Merchant_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Merchant_Name_Data property can only contain items of type \StructType\Alternate_Merchant_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Merchant_Name_Data[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Hotel_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
