<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing expense report response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Expense_Report_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Report_WWSType[]
     */
    public $Expense_Report;
    /**
     * Constructor method for Expense_Report_Response_DataType
     * @uses Expense_Report_Response_DataType::setExpense_Report()
     * @param \StructType\Expense_Report_WWSType[] $expense_Report
     */
    public function __construct(array $expense_Report = array())
    {
        $this
            ->setExpense_Report($expense_Report);
    }
    /**
     * Get Expense_Report value
     * @return \StructType\Expense_Report_WWSType[]|null
     */
    public function getExpense_Report()
    {
        return $this->Expense_Report;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_ReportForArrayConstraintsFromSetExpense_Report(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Response_DataTypeExpense_ReportItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Response_DataTypeExpense_ReportItem instanceof \StructType\Expense_Report_WWSType) {
                $invalidValues[] = is_object($expense_Report_Response_DataTypeExpense_ReportItem) ? get_class($expense_Report_Response_DataTypeExpense_ReportItem) : sprintf('%s(%s)', gettype($expense_Report_Response_DataTypeExpense_ReportItem), var_export($expense_Report_Response_DataTypeExpense_ReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report property can only contain items of type \StructType\Expense_Report_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_WWSType[] $expense_Report
     * @return \StructType\Expense_Report_Response_DataType
     */
    public function setExpense_Report(array $expense_Report = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_ReportArrayErrorMessage = self::validateExpense_ReportForArrayConstraintsFromSetExpense_Report($expense_Report))) {
            throw new \InvalidArgumentException($expense_ReportArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report = $expense_Report;
        return $this;
    }
    /**
     * Add item to Expense_Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_WWSType $item
     * @return \StructType\Expense_Report_Response_DataType
     */
    public function addToExpense_Report(\StructType\Expense_Report_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Report_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report property can only contain items of type \StructType\Expense_Report_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report[] = $item;
        return $this;
    }
}
