<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Order_Service_Order_Line_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Service Purchase Order Line data. Specify only lines that need to be changed / added.
 * @subpackage Structs
 */
class Change_Order_Service_Order_Line_WWS_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: ID of Purcahse Order Line that is being changed
     * - minOccurs: 0
     * @var \StructType\Order_Service_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Change_Order_Line_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line Reference ID on the change order. If provided, this ID needs to be different from the Reference ID on the purchase order line being changed
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Change_Order_Line_Reference_ID;
    /**
     * The Cancel_PO_Line
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Order Line will be canceled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Cancel_PO_Line;
    /**
     * The Service_Order_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: This value becomes Purchase Order Line Reference ID of the Purchase Order Line when change order is approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Service_Order_Line_ID;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing purchase item. Specifying the purchase item will default values for the Item Description, Spend Category, Tax Applicability, Unit of Measure, and Unit Cost if these options are defined on the purchase item
     * itself.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text description of the purchase item. The description will default from the item if the description is left blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend Category for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Applicability for the Purchase Item. If the item has Tax Code defined, then the Tax Applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Code for the Purchase Item. The Tax Code is defaulted from the Change Order Header if one is specified.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Options_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Options_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: The anticipated date by which the Purchase Order Line should be fulfilled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Retention_Line
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention_Line;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a change order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference instance or a Address Reference ID for an existing address
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ship-to contact worker associated to the line item.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing location for the item.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Remove_Line_Splits
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the splits for the Purchase Order Line will be removed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Remove_Line_Splits;
    /**
     * The Change_Order_Service_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Change_Order_Line_Split_WWS_DataType[]
     */
    public $Change_Order_Service_Line_Split_Data;
    /**
     * Constructor method for Change_Order_Service_Order_Line_WWS_DataType
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setPurchase_Order_Line_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setChange_Order_Line_Reference_ID()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setCancel_PO_Line()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setService_Order_Line_ID()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setLine_Number()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setLine_Company_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setItem_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setDescription()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setCommodity_Code_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setResource_Category_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setTax_Applicability_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setTax_Code_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setTax_Rate_Options_Data()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setExtended_Amount()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setDue_Date()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setStart_Date()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setEnd_Date()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setRetention_Line()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setPrepaid()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setBudget_Date()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setMemo()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setShip_To_Address_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setShip_To_Contact_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setDeliver_To_Location_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setSupplier_Contract_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setStorage_Location_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setWorktags_Reference()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setRemove_Line_Splits()
     * @uses Change_Order_Service_Order_Line_WWS_DataType::setChange_Order_Service_Line_Split_Data()
     * @param \StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference
     * @param string $change_Order_Line_Reference_ID
     * @param bool $cancel_PO_Line
     * @param string $service_Order_Line_ID
     * @param float $line_Number
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $description
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @param float $extended_Amount
     * @param string $due_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param bool $retention_Line
     * @param bool $prepaid
     * @param string $budget_Date
     * @param string $memo
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param bool $remove_Line_Splits
     * @param \StructType\Change_Order_Line_Split_WWS_DataType[] $change_Order_Service_Line_Split_Data
     */
    public function __construct(\StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference = null, $change_Order_Line_Reference_ID = null, $cancel_PO_Line = null, $service_Order_Line_ID = null, $line_Number = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $description = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null, $extended_Amount = null, $due_Date = null, $start_Date = null, $end_Date = null, $retention_Line = null, $prepaid = null, $budget_Date = null, $memo = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $worktags_Reference = array(), $remove_Line_Splits = null, array $change_Order_Service_Line_Split_Data = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setChange_Order_Line_Reference_ID($change_Order_Line_Reference_ID)
            ->setCancel_PO_Line($cancel_PO_Line)
            ->setService_Order_Line_ID($service_Order_Line_ID)
            ->setLine_Number($line_Number)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setDescription($description)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Options_Data($tax_Rate_Options_Data)
            ->setExtended_Amount($extended_Amount)
            ->setDue_Date($due_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setRetention_Line($retention_Line)
            ->setPrepaid($prepaid)
            ->setBudget_Date($budget_Date)
            ->setMemo($memo)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setRemove_Line_Splits($remove_Line_Splits)
            ->setChange_Order_Service_Line_Split_Data($change_Order_Service_Line_Split_Data);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Order_Service_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Order_Service_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Line_Reference_ID value
     * @return string|null
     */
    public function getChange_Order_Line_Reference_ID()
    {
        return $this->Change_Order_Line_Reference_ID;
    }
    /**
     * Set Change_Order_Line_Reference_ID value
     * @param string $change_Order_Line_Reference_ID
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setChange_Order_Line_Reference_ID($change_Order_Line_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($change_Order_Line_Reference_ID) && !is_string($change_Order_Line_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_Order_Line_Reference_ID, true), gettype($change_Order_Line_Reference_ID)), __LINE__);
        }
        $this->Change_Order_Line_Reference_ID = $change_Order_Line_Reference_ID;
        return $this;
    }
    /**
     * Get Cancel_PO_Line value
     * @return bool|null
     */
    public function getCancel_PO_Line()
    {
        return $this->Cancel_PO_Line;
    }
    /**
     * Set Cancel_PO_Line value
     * @param bool $cancel_PO_Line
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setCancel_PO_Line($cancel_PO_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancel_PO_Line) && !is_bool($cancel_PO_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancel_PO_Line, true), gettype($cancel_PO_Line)), __LINE__);
        }
        $this->Cancel_PO_Line = $cancel_PO_Line;
        return $this;
    }
    /**
     * Get Service_Order_Line_ID value
     * @return string|null
     */
    public function getService_Order_Line_ID()
    {
        return $this->Service_Order_Line_ID;
    }
    /**
     * Set Service_Order_Line_ID value
     * @param string $service_Order_Line_ID
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setService_Order_Line_ID($service_Order_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($service_Order_Line_ID) && !is_string($service_Order_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service_Order_Line_ID, true), gettype($service_Order_Line_ID)), __LINE__);
        }
        $this->Service_Order_Line_ID = $service_Order_Line_ID;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Options_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Options_Data()
    {
        return $this->Tax_Rate_Options_Data;
    }
    /**
     * Set Tax_Rate_Options_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setTax_Rate_Options_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null)
    {
        $this->Tax_Rate_Options_Data = $tax_Rate_Options_Data;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Retention_Line value
     * @return bool|null
     */
    public function getRetention_Line()
    {
        return $this->Retention_Line;
    }
    /**
     * Set Retention_Line value
     * @param bool $retention_Line
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setRetention_Line($retention_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention_Line) && !is_bool($retention_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention_Line, true), gettype($retention_Line)), __LINE__);
        }
        $this->Retention_Line = $retention_Line;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem) ? get_class($change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem), var_export($change_Order_Service_Order_Line_WWS_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Remove_Line_Splits value
     * @return bool|null
     */
    public function getRemove_Line_Splits()
    {
        return $this->Remove_Line_Splits;
    }
    /**
     * Set Remove_Line_Splits value
     * @param bool $remove_Line_Splits
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setRemove_Line_Splits($remove_Line_Splits = null)
    {
        // validation for constraint: boolean
        if (!is_null($remove_Line_Splits) && !is_bool($remove_Line_Splits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($remove_Line_Splits, true), gettype($remove_Line_Splits)), __LINE__);
        }
        $this->Remove_Line_Splits = $remove_Line_Splits;
        return $this;
    }
    /**
     * Get Change_Order_Service_Line_Split_Data value
     * @return \StructType\Change_Order_Line_Split_WWS_DataType[]|null
     */
    public function getChange_Order_Service_Line_Split_Data()
    {
        return $this->Change_Order_Service_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setChange_Order_Service_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChange_Order_Service_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChange_Order_Service_Line_Split_DataForArrayConstraintsFromSetChange_Order_Service_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem instanceof \StructType\Change_Order_Line_Split_WWS_DataType) {
                $invalidValues[] = is_object($change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem) ? get_class($change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem) : sprintf('%s(%s)', gettype($change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem), var_export($change_Order_Service_Order_Line_WWS_DataTypeChange_Order_Service_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Change_Order_Service_Line_Split_Data property can only contain items of type \StructType\Change_Order_Line_Split_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Change_Order_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Line_Split_WWS_DataType[] $change_Order_Service_Line_Split_Data
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function setChange_Order_Service_Line_Split_Data(array $change_Order_Service_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($change_Order_Service_Line_Split_DataArrayErrorMessage = self::validateChange_Order_Service_Line_Split_DataForArrayConstraintsFromSetChange_Order_Service_Line_Split_Data($change_Order_Service_Line_Split_Data))) {
            throw new \InvalidArgumentException($change_Order_Service_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Change_Order_Service_Line_Split_Data = $change_Order_Service_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Change_Order_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Line_Split_WWS_DataType $item
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType
     */
    public function addToChange_Order_Service_Line_Split_Data(\StructType\Change_Order_Line_Split_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Change_Order_Line_Split_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Change_Order_Service_Line_Split_Data property can only contain items of type \StructType\Change_Order_Line_Split_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Change_Order_Service_Line_Split_Data[] = $item;
        return $this;
    }
}
