<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request Criteria is a wrapper element around a list of elements representing the operation specific criteria needed to search for assets.
 * @subpackage Structs
 */
class Asset_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Company references to use to filter the assets returned in the response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Issued_To_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Worker references to use to find assets currently issues to those Workers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Issued_To_Worker_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Spend Categories to find assets belonging to those categories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Purchase Item references to find assets related to those items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Item_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Locations to find assets currently placed in those locations.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Location_Reference;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: An Asset Identifier value to be used to find any exsisting assets with the matching Asset Identifier value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Serial_Number
     * Meta information extracted from the WSDL
     * - documentation: A value to be used to find any existing assets with a matching Serial Number value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Number;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Worktag references to be used to find Assets currently assigned any of these worktags. To filter based on Location, use the Location Reference element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Asset_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Asset Status reference to use to find assets currently in those statuses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Asset_Status_Reference;
    /**
     * The Acquisition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Acquisition Method references to use to find assets acquired using one of those methods.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Acquisition_MethodObjectType[]
     */
    public $Acquisition_Method_Reference;
    /**
     * The Disposal_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Asset Disposal Method references to find assets disposed of using those methods.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Asset_Disposal_MethodObjectType[]
     */
    public $Disposal_Method_Reference;
    /**
     * The Acquired_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to find assets by the date they were acquired. This is the From Date to find assets by acquisition date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquired_From_Date;
    /**
     * The Acquired_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to find assets by the date they were acquired. This is the To Date to find assets by acquisition date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquired_To_Date;
    /**
     * The Updated_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to find assets by when they were updated. This is the From Date to use to find all types of asset activity within a date range (Acquisition, Cost Adjustment, Disposal, Reinstatement, Issue, Transfer). Assets with activity
     * in this date range will be returned in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_From_Date;
    /**
     * The Updated_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to find assets by when they were updated. This is the To Date to use to find all types of asset activity within a date range (Acquisition, Cost Adjustment, Disposal, Reinstatement, Issue, Transfer). Assets with activity in
     * this date range will be returned in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_To_Date;
    /**
     * Constructor method for Asset_Request_CriteriaType
     * @uses Asset_Request_CriteriaType::setCompany_Reference()
     * @uses Asset_Request_CriteriaType::setIssued_To_Worker_Reference()
     * @uses Asset_Request_CriteriaType::setSpend_Category_Reference()
     * @uses Asset_Request_CriteriaType::setItem_Reference()
     * @uses Asset_Request_CriteriaType::setLocation_Reference()
     * @uses Asset_Request_CriteriaType::setAsset_Identifier()
     * @uses Asset_Request_CriteriaType::setSerial_Number()
     * @uses Asset_Request_CriteriaType::setWorktag_Reference()
     * @uses Asset_Request_CriteriaType::setAsset_Status_Reference()
     * @uses Asset_Request_CriteriaType::setAcquisition_Method_Reference()
     * @uses Asset_Request_CriteriaType::setDisposal_Method_Reference()
     * @uses Asset_Request_CriteriaType::setAcquired_From_Date()
     * @uses Asset_Request_CriteriaType::setAcquired_To_Date()
     * @uses Asset_Request_CriteriaType::setUpdated_From_Date()
     * @uses Asset_Request_CriteriaType::setUpdated_To_Date()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param \StructType\WorkerObjectType[] $issued_To_Worker_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param \StructType\Purchase_ItemObjectType[] $item_Reference
     * @param \StructType\LocationObjectType[] $location_Reference
     * @param string $asset_Identifier
     * @param string $serial_Number
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Document_StatusObjectType[] $asset_Status_Reference
     * @param \StructType\Acquisition_MethodObjectType[] $acquisition_Method_Reference
     * @param \StructType\Business_Asset_Disposal_MethodObjectType[] $disposal_Method_Reference
     * @param string $acquired_From_Date
     * @param string $acquired_To_Date
     * @param string $updated_From_Date
     * @param string $updated_To_Date
     */
    public function __construct(array $company_Reference = array(), array $issued_To_Worker_Reference = array(), array $spend_Category_Reference = array(), array $item_Reference = array(), array $location_Reference = array(), $asset_Identifier = null, $serial_Number = null, array $worktag_Reference = array(), array $asset_Status_Reference = array(), array $acquisition_Method_Reference = array(), array $disposal_Method_Reference = array(), $acquired_From_Date = null, $acquired_To_Date = null, $updated_From_Date = null, $updated_To_Date = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setIssued_To_Worker_Reference($issued_To_Worker_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setItem_Reference($item_Reference)
            ->setLocation_Reference($location_Reference)
            ->setAsset_Identifier($asset_Identifier)
            ->setSerial_Number($serial_Number)
            ->setWorktag_Reference($worktag_Reference)
            ->setAsset_Status_Reference($asset_Status_Reference)
            ->setAcquisition_Method_Reference($acquisition_Method_Reference)
            ->setDisposal_Method_Reference($disposal_Method_Reference)
            ->setAcquired_From_Date($acquired_From_Date)
            ->setAcquired_To_Date($acquired_To_Date)
            ->setUpdated_From_Date($updated_From_Date)
            ->setUpdated_To_Date($updated_To_Date);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($asset_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeCompany_ReferenceItem), var_export($asset_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Issued_To_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getIssued_To_Worker_Reference()
    {
        return $this->Issued_To_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIssued_To_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssued_To_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIssued_To_Worker_ReferenceForArrayConstraintsFromSetIssued_To_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem) ? get_class($asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem), var_export($asset_Request_CriteriaTypeIssued_To_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Issued_To_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Issued_To_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $issued_To_Worker_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setIssued_To_Worker_Reference(array $issued_To_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($issued_To_Worker_ReferenceArrayErrorMessage = self::validateIssued_To_Worker_ReferenceForArrayConstraintsFromSetIssued_To_Worker_Reference($issued_To_Worker_Reference))) {
            throw new \InvalidArgumentException($issued_To_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Issued_To_Worker_Reference = $issued_To_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Issued_To_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToIssued_To_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Issued_To_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Issued_To_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($asset_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($asset_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_ReferenceForArrayConstraintsFromSetItem_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeItem_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeItem_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeItem_ReferenceItem) ? get_class($asset_Request_CriteriaTypeItem_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeItem_ReferenceItem), var_export($asset_Request_CriteriaTypeItem_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $item_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setItem_Reference(array $item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_ReferenceArrayErrorMessage = self::validateItem_ReferenceForArrayConstraintsFromSetItem_Reference($item_Reference))) {
            throw new \InvalidArgumentException($item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Add item to Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToItem_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeLocation_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeLocation_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeLocation_ReferenceItem) ? get_class($asset_Request_CriteriaTypeLocation_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeLocation_ReferenceItem), var_export($asset_Request_CriteriaTypeLocation_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $location_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setLocation_Reference(array $location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_ReferenceArrayErrorMessage = self::validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference($location_Reference))) {
            throw new \InvalidArgumentException($location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Add item to Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToLocation_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Serial_Number value
     * @return string|null
     */
    public function getSerial_Number()
    {
        return $this->Serial_Number;
    }
    /**
     * Set Serial_Number value
     * @param string $serial_Number
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setSerial_Number($serial_Number = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Number) && !is_string($serial_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Number, true), gettype($serial_Number)), __LINE__);
        }
        $this->Serial_Number = $serial_Number;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeWorktag_ReferenceItem) ? get_class($asset_Request_CriteriaTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeWorktag_ReferenceItem), var_export($asset_Request_CriteriaTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getAsset_Status_Reference()
    {
        return $this->Asset_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Status_ReferenceForArrayConstraintsFromSetAsset_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeAsset_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeAsset_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeAsset_Status_ReferenceItem) ? get_class($asset_Request_CriteriaTypeAsset_Status_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeAsset_Status_ReferenceItem), var_export($asset_Request_CriteriaTypeAsset_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $asset_Status_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setAsset_Status_Reference(array $asset_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Status_ReferenceArrayErrorMessage = self::validateAsset_Status_ReferenceForArrayConstraintsFromSetAsset_Status_Reference($asset_Status_Reference))) {
            throw new \InvalidArgumentException($asset_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Status_Reference = $asset_Status_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToAsset_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acquisition_Method_Reference value
     * @return \StructType\Acquisition_MethodObjectType[]|null
     */
    public function getAcquisition_Method_Reference()
    {
        return $this->Acquisition_Method_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAcquisition_Method_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcquisition_Method_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcquisition_Method_ReferenceForArrayConstraintsFromSetAcquisition_Method_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem instanceof \StructType\Acquisition_MethodObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem) ? get_class($asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem), var_export($asset_Request_CriteriaTypeAcquisition_Method_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Acquisition_Method_Reference property can only contain items of type \StructType\Acquisition_MethodObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Acquisition_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Acquisition_MethodObjectType[] $acquisition_Method_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setAcquisition_Method_Reference(array $acquisition_Method_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($acquisition_Method_ReferenceArrayErrorMessage = self::validateAcquisition_Method_ReferenceForArrayConstraintsFromSetAcquisition_Method_Reference($acquisition_Method_Reference))) {
            throw new \InvalidArgumentException($acquisition_Method_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Acquisition_Method_Reference = $acquisition_Method_Reference;
        return $this;
    }
    /**
     * Add item to Acquisition_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Acquisition_MethodObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToAcquisition_Method_Reference(\StructType\Acquisition_MethodObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Acquisition_MethodObjectType) {
            throw new \InvalidArgumentException(sprintf('The Acquisition_Method_Reference property can only contain items of type \StructType\Acquisition_MethodObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Acquisition_Method_Reference[] = $item;
        return $this;
    }
    /**
     * Get Disposal_Method_Reference value
     * @return \StructType\Business_Asset_Disposal_MethodObjectType[]|null
     */
    public function getDisposal_Method_Reference()
    {
        return $this->Disposal_Method_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDisposal_Method_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisposal_Method_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisposal_Method_ReferenceForArrayConstraintsFromSetDisposal_Method_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_CriteriaTypeDisposal_Method_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_CriteriaTypeDisposal_Method_ReferenceItem instanceof \StructType\Business_Asset_Disposal_MethodObjectType) {
                $invalidValues[] = is_object($asset_Request_CriteriaTypeDisposal_Method_ReferenceItem) ? get_class($asset_Request_CriteriaTypeDisposal_Method_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_CriteriaTypeDisposal_Method_ReferenceItem), var_export($asset_Request_CriteriaTypeDisposal_Method_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disposal_Method_Reference property can only contain items of type \StructType\Business_Asset_Disposal_MethodObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disposal_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Asset_Disposal_MethodObjectType[] $disposal_Method_Reference
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setDisposal_Method_Reference(array $disposal_Method_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($disposal_Method_ReferenceArrayErrorMessage = self::validateDisposal_Method_ReferenceForArrayConstraintsFromSetDisposal_Method_Reference($disposal_Method_Reference))) {
            throw new \InvalidArgumentException($disposal_Method_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Disposal_Method_Reference = $disposal_Method_Reference;
        return $this;
    }
    /**
     * Add item to Disposal_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Asset_Disposal_MethodObjectType $item
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function addToDisposal_Method_Reference(\StructType\Business_Asset_Disposal_MethodObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Asset_Disposal_MethodObjectType) {
            throw new \InvalidArgumentException(sprintf('The Disposal_Method_Reference property can only contain items of type \StructType\Business_Asset_Disposal_MethodObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disposal_Method_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acquired_From_Date value
     * @return string|null
     */
    public function getAcquired_From_Date()
    {
        return $this->Acquired_From_Date;
    }
    /**
     * Set Acquired_From_Date value
     * @param string $acquired_From_Date
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setAcquired_From_Date($acquired_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquired_From_Date) && !is_string($acquired_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquired_From_Date, true), gettype($acquired_From_Date)), __LINE__);
        }
        $this->Acquired_From_Date = $acquired_From_Date;
        return $this;
    }
    /**
     * Get Acquired_To_Date value
     * @return string|null
     */
    public function getAcquired_To_Date()
    {
        return $this->Acquired_To_Date;
    }
    /**
     * Set Acquired_To_Date value
     * @param string $acquired_To_Date
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setAcquired_To_Date($acquired_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquired_To_Date) && !is_string($acquired_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquired_To_Date, true), gettype($acquired_To_Date)), __LINE__);
        }
        $this->Acquired_To_Date = $acquired_To_Date;
        return $this;
    }
    /**
     * Get Updated_From_Date value
     * @return string|null
     */
    public function getUpdated_From_Date()
    {
        return $this->Updated_From_Date;
    }
    /**
     * Set Updated_From_Date value
     * @param string $updated_From_Date
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setUpdated_From_Date($updated_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_From_Date) && !is_string($updated_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_From_Date, true), gettype($updated_From_Date)), __LINE__);
        }
        $this->Updated_From_Date = $updated_From_Date;
        return $this;
    }
    /**
     * Get Updated_To_Date value
     * @return string|null
     */
    public function getUpdated_To_Date()
    {
        return $this->Updated_To_Date;
    }
    /**
     * Set Updated_To_Date value
     * @param string $updated_To_Date
     * @return \StructType\Asset_Request_CriteriaType
     */
    public function setUpdated_To_Date($updated_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_To_Date) && !is_string($updated_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_To_Date, true), gettype($updated_To_Date)), __LINE__);
        }
        $this->Updated_To_Date = $updated_To_Date;
        return $this;
    }
}
