<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Rule_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request references for the asset book rules operation
 * @subpackage Structs
 */
class Asset_Book_Rule_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing asset book to which the asset book rule data applies
     * - maxOccurs: unbounded
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Asset_Book_Reference;
    /**
     * Constructor method for Asset_Book_Rule_Request_ReferencesType
     * @uses Asset_Book_Rule_Request_ReferencesType::setAsset_Book_Reference()
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     */
    public function __construct(array $asset_Book_Reference = array())
    {
        $this
            ->setAsset_Book_Reference($asset_Book_Reference);
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem) ? get_class($asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem), var_export($asset_Book_Rule_Request_ReferencesTypeAsset_Book_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @return \StructType\Asset_Book_Rule_Request_ReferencesType
     */
    public function setAsset_Book_Reference(array $asset_Book_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_ReferenceArrayErrorMessage = self::validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference($asset_Book_Reference))) {
            throw new \InvalidArgumentException($asset_Book_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Asset_Book_Rule_Request_ReferencesType
     */
    public function addToAsset_Book_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Reference[] = $item;
        return $this;
    }
}
