<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Street_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: address line for an address
 * @subpackage Structs
 */
class Street_Line_DataType extends AbstractStructBase
{
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - documentation: Address line for an address. Can have multiple lines, but only one per Street Line Data element.
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * Constructor method for Street_Line_DataType
     * @uses Street_Line_DataType::setStreet()
     * @param string $street
     */
    public function __construct($street = null)
    {
        $this
            ->setStreet($street);
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\Street_Line_DataType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
}
