<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Revenue_Center_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Revenue Center reference for update and all Revenue Center data items
 * @subpackage Structs
 */
class Put_Revenue_Center_RequestType extends AbstractStructBase
{
    /**
     * The Revenue_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Revenue Center for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Revenue_CenterObjectType
     */
    public $Revenue_Center_Reference;
    /**
     * The Revenue_Center_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Revenue Center Data
     * @var \StructType\Revenue_Center_DataType
     */
    public $Revenue_Center_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Revenue_Center_RequestType
     * @uses Put_Revenue_Center_RequestType::setRevenue_Center_Reference()
     * @uses Put_Revenue_Center_RequestType::setRevenue_Center_Data()
     * @uses Put_Revenue_Center_RequestType::setAdd_Only()
     * @uses Put_Revenue_Center_RequestType::setVersion()
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @param \StructType\Revenue_Center_DataType $revenue_Center_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Revenue_CenterObjectType $revenue_Center_Reference = null, \StructType\Revenue_Center_DataType $revenue_Center_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRevenue_Center_Reference($revenue_Center_Reference)
            ->setRevenue_Center_Data($revenue_Center_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Revenue_Center_Reference value
     * @return \StructType\Revenue_CenterObjectType|null
     */
    public function getRevenue_Center_Reference()
    {
        return $this->Revenue_Center_Reference;
    }
    /**
     * Set Revenue_Center_Reference value
     * @param \StructType\Revenue_CenterObjectType $revenue_Center_Reference
     * @return \StructType\Put_Revenue_Center_RequestType
     */
    public function setRevenue_Center_Reference(\StructType\Revenue_CenterObjectType $revenue_Center_Reference = null)
    {
        $this->Revenue_Center_Reference = $revenue_Center_Reference;
        return $this;
    }
    /**
     * Get Revenue_Center_Data value
     * @return \StructType\Revenue_Center_DataType|null
     */
    public function getRevenue_Center_Data()
    {
        return $this->Revenue_Center_Data;
    }
    /**
     * Set Revenue_Center_Data value
     * @param \StructType\Revenue_Center_DataType $revenue_Center_Data
     * @return \StructType\Put_Revenue_Center_RequestType
     */
    public function setRevenue_Center_Data(\StructType\Revenue_Center_DataType $revenue_Center_Data = null)
    {
        $this->Revenue_Center_Data = $revenue_Center_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Revenue_Center_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Revenue_Center_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
