<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Procurement_Card_Transaction_Verification_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Procurement Card Transaction Verification Reference element contains the specific instance set containing the requested Procurement Card Transaction Verification.
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Procurement_Card_Transaction_Verification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Procurement Card Transaction Verification object.
     * - maxOccurs: unbounded
     * @var \StructType\Procurement_Card_Transaction_VerificationObjectType[]
     */
    public $Procurement_Card_Transaction_Verification_Reference;
    /**
     * Constructor method for
     * Procurement_Card_Transaction_Verification_Request_ReferencesType
     * @uses Procurement_Card_Transaction_Verification_Request_ReferencesType::setProcurement_Card_Transaction_Verification_Reference()
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType[] $procurement_Card_Transaction_Verification_Reference
     */
    public function __construct(array $procurement_Card_Transaction_Verification_Reference = array())
    {
        $this
            ->setProcurement_Card_Transaction_Verification_Reference($procurement_Card_Transaction_Verification_Reference);
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Reference value
     * @return \StructType\Procurement_Card_Transaction_VerificationObjectType[]|null
     */
    public function getProcurement_Card_Transaction_Verification_Reference()
    {
        return $this->Procurement_Card_Transaction_Verification_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Card_Transaction_Verification_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Card_Transaction_Verification_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Card_Transaction_Verification_ReferenceForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem instanceof \StructType\Procurement_Card_Transaction_VerificationObjectType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem) ? get_class($procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem), var_export($procurement_Card_Transaction_Verification_Request_ReferencesTypeProcurement_Card_Transaction_Verification_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Card_Transaction_Verification_Reference property can only contain items of type \StructType\Procurement_Card_Transaction_VerificationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType[] $procurement_Card_Transaction_Verification_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_ReferencesType
     */
    public function setProcurement_Card_Transaction_Verification_Reference(array $procurement_Card_Transaction_Verification_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Card_Transaction_Verification_ReferenceArrayErrorMessage = self::validateProcurement_Card_Transaction_Verification_ReferenceForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Reference($procurement_Card_Transaction_Verification_Reference))) {
            throw new \InvalidArgumentException($procurement_Card_Transaction_Verification_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Reference = $procurement_Card_Transaction_Verification_Reference;
        return $this;
    }
    /**
     * Add item to Procurement_Card_Transaction_Verification_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_ReferencesType
     */
    public function addToProcurement_Card_Transaction_Verification_Reference(\StructType\Procurement_Card_Transaction_VerificationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Card_Transaction_VerificationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Card_Transaction_Verification_Reference property can only contain items of type \StructType\Procurement_Card_Transaction_VerificationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Reference[] = $item;
        return $this;
    }
}
