<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Expense_Report_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element encapsulating the reference to the expense report that was canceled.
 * @subpackage Structs
 */
class Cancel_Expense_Report_ResponseType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to expense report that was canceled.
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Expense_Report_ResponseType
     * @uses Cancel_Expense_Report_ResponseType::setExpense_Report_Reference()
     * @uses Cancel_Expense_Report_ResponseType::setVersion()
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param string $version
     */
    public function __construct(\StructType\Expense_ReportObjectType $expense_Report_Reference = null, $version = null)
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setVersion($version);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Cancel_Expense_Report_ResponseType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Expense_Report_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
