<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @subpackage Services
 */
class Submit extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Invoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Invoices and submit to the Supplier Invoice business process. Supplier Invoice Adjustment data includes Supplier Invoice Adjustment ID, Submit Flag, Locked in Workday Flag, Document
     * Number, Company, Currency, Supplier, Contingent Worker, Document Date, Due Date Override, Control Total Amount, Payment Terms, Hold from Payment Flag, Document Received, Reference, PO Number, Contract, Memo, Attachment and Supplier Invoice Line data.
     * Line data includes Intercompany Affiliate, Purchase Item, Purchase Order Line, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo and Worktags.Spend Category and Resource Category are synonymous and refer to the same business object.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Invoice_RequestType $body
     * @return \StructType\Submit_Supplier_Invoice_ResponseType|bool
     */
    public function Submit_Supplier_Invoice(\StructType\Submit_Supplier_Invoice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Invoice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Invoice_Adjustment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Invoice Adjustments and submit to the Supplier Invoice Adjustment business process. Supplier Invoice Adjustment data includes Supplier Invoice Adjustment ID, Submit Flag, Locked in
     * Workday Flag, Document Number, Company, Currency, Supplier, Contingent Worker, Increase Liability Flag, Adjustment Reason, Adjustment Date, Due Date Override, Control Total Amount, Original Invoice, Payment Terms, Hold from Payment Flag, Document
     * Received, Reference, PO Number, Contract, Memo, Attachment and Supplier Invoice Line data. Line data includes Intercompany Affiliate, Purchase Item, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo and Worktags.Spend Category and
     * Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Invoice_Adjustment_RequestType $body
     * @return \StructType\Submit_Supplier_Invoice_Adjustment_ResponseType|bool
     */
    public function Submit_Supplier_Invoice_Adjustment(\StructType\Submit_Supplier_Invoice_Adjustment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Invoice_Adjustment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Catalog_Load
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Catalog Items. Catalog Load Requests contain supplier specific Catalog Items and effective dated pricing. Catalog Load Requests can be associated with Supplier Contracts. Once a Catalog Load
     * Request is fully approved Catalog Items are available for use on Requisitions and Purchase Orders based on their effective date. Catalog Loads include data such as Supplier, Supplier Contract, Effective Date, memo and item details such as Item ID,
     * Item Name, Item Description, Unit of Measure and Unit Price.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Catalog_Load_RequestType $body
     * @return \StructType\Submit_Catalog_Load_ResponseType|bool
     */
    public function Submit_Catalog_Load(\StructType\Submit_Catalog_Load_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Catalog_Load($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Expense_Report
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Expense Reports and submit them to the Expense Report Event Business Process. Expense Report data includes Date, Business Purpose, Spend Authorization, Total Amount, Payment Type, Memo, and
     * Expense Report Lines. The data for the lines includes Date, Quantity, Amount, Expense Item, Conversion Rate, Converted Amount, Expense Item Attributes, Credit Card, Credit Card Transaction, Memo, Flags for Billable and Receipt Included, and
     * Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Expense_Report_RequestType $body
     * @return \StructType\Submit_Expense_Report_ResponseType|bool
     */
    public function Submit_Expense_Report(\StructType\Submit_Expense_Report_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Expense_Report($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Purchase_Order
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add a Goods or Deliverables Purchase Order and submit it to the PO Collaboration business process. Any goods items that have applicable taxes will also include tax data. Contingent Worker Purchase Orders
     * are not supported in this version of the web service. You will only be able to update existing Goods or Deliverables Orders which are in draft status (not in progress, approved, canceled, issued, issuing, or change order in process)No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Purchase_Order_RequestType $body
     * @return \StructType\Submit_Purchase_Order_ResponseType|bool
     */
    public function Submit_Purchase_Order(\StructType\Submit_Purchase_Order_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Purchase_Order($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Expense_Report_for_Applicant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Expense Reports for Applicants and submit them to the Expense Report Event Business Process. Expense Report data includes Date, Business Purpose, Spend Authorization, Total Amount, Payment
     * Type, Memo, and Expense Report Lines. The data for the lines includes Date, Quantity, Amount, Expense Item, Conversion Rate, Converted Amount, Expense Item Attributes, Credit Card, Credit Card Transaction, Memo, Flags for Billable and Receipt
     * Included, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Expense_Report_for_Applicant_RequestType $body
     * @return \StructType\Submit_Expense_Report_for_Applicant_ResponseType|bool
     */
    public function Submit_Expense_Report_for_Applicant(\StructType\Submit_Expense_Report_for_Applicant_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Expense_Report_for_Applicant($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Invoice_Contract
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Recurring Supplier Invoices (formerly Supplier Invoice Contracts) and submit to the Recurring Supplier Invoice business process. Supplier Invoice Contract was renamed to Recurring Supplier
     * Invoice and refer to the same business object.Recurring Supplier Invoice data includes ID,Supplier Contract Name, Supplier, Supplier Reference Number, Company, Currency, Contract Overview, Payment Terms, Selection of Fixed or Variable Contract,
     * Frequency Type, Contract Start Date, First Invoice date, Supplier Contract End Date, Total Contract Amount, Tax, Attachment and Supplier Invoice Line data. Line data includes Intercompany Affiliate, Purchase Item, Purchase Order Line, Spend Category,
     * Quantity, Unit Cost, Extended Amount, Line Memo and Worktags. The request criteria can be for a single transaction based on Reference or Contract Number, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Invoice_Contract_RequestType $body
     * @return \StructType\Submit_Supplier_Invoice_Contract_ResponseType|bool
     */
    public function Submit_Supplier_Invoice_Contract(\StructType\Submit_Supplier_Invoice_Contract_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Invoice_Contract($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Order_Contract
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation is being deprecated in favor of the Submit Supplier Contract web service in W16.This service operation will add Supplier Order Contracts and submit to the Supplier Order Contract business process. . Supplier Order
     * Contract data includes Supplier Contract ID, Supplier Contract Name, Resource Provider, Supplier Contract Reference Number, Company, Buyer, Contract Start Date, Contract End Date, Currency, Total Contract Amount, Currency, Contract Overview, Locked
     * in Workday Flag and Attachment data.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Order_Contract_RequestType $body
     * @return \StructType\Submit_Supplier_Order_Contract_ResponseType|bool
     */
    public function Submit_Supplier_Order_Contract(\StructType\Submit_Supplier_Order_Contract_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Order_Contract($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Receipt
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add Receipts and submit to the Receipt business process. Receipt data includes Receipt Number, Company, Supplier, Document Date, Created for Worker (for Contingent Worker Receipts only), Memo, Attachment
     * data, and Receipt Line. For a Goods Receipt Line, there is a Purchase Order Line Reference, and Quantity Received. For a Contingent Worker Receipt Line there is a Purchase Order Line Reference, Period Start Date, Period End Date, Hours Worked Data,
     * Additional Amount, Amount to Receive, and Line Memo. Only goods receipt lines or contingent worker receipt lines can be submitted, but not at the same time. A Contingent Worker Receipt can have only one Contingent Worker Receipt Line, which must
     * match with the Purchase Order Line's information regarding Time Codes, dates, and Contingent Worker.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Receipt_RequestType $body
     * @return \StructType\Submit_Receipt_ResponseType|bool
     */
    public function Submit_Receipt(\StructType\Submit_Receipt_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Receipt($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Requisitions and submit to the Requisition business process. Requisition Data include Requisition Number, Requisition Date, Company, Ship-To Address, Requester, High Priority, Item Request
     * Line Data, Deliverables Line Data and Attachment Data. Item Request Line Data include Requisition Goods Line, Item, Item Description, Spend Category, Supplier, Supplier Contract, Quantity, Unit of Measure, Unit Cost, Extended Amount, Memo, and
     * Worktags. Deliverables Line Data include Deliverables Line, Project, Memo, Spend Category, Project Phase Data, Extended Amount, and Worktags. Project Phase Data includes Project Plan Phase and Project Plan Task Data. Project Plan Task Data include
     * Project Plan Task and Project Subtask Data. Project Subtask Data include Description and Amount. Contingent Worker (Job) Requisitions are not supported on this version of the web service.Spend Category and Resource Category are synonymous and refer
     * to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Requisition_RequestType $body
     * @return \StructType\Submit_Requisition_ResponseType|bool
     */
    public function Submit_Requisition(\StructType\Submit_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Spend_Authorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates Spend Authorizations and submits them to the Spend Authorization Event Business Process. Spend Authorization data includes Worker, Company, Date, Description, Justification, Estimated Amount, Spend Authorization
     * Lines, and Attachments. The Spend Authorization lines include: Expense Item, Quantity, Unit Cost, Billable flag, Worktags, and Memo.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Spend_Authorization_RequestType $body
     * @return \StructType\Submit_Spend_Authorization_ResponseType|bool
     */
    public function Submit_Spend_Authorization(\StructType\Submit_Spend_Authorization_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Spend_Authorization($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Contract
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates Supplier Contracts and optionally submits them to the Supplier Contract business process. Supplier Contract data includes Supplier Contract ID; Company or Company Hierarchy; Supplier; Contract Specialist; Buyer;
     * Supplier Contract Type; Contract Name; Supplier Reference Number; Contract Start, Signed, and End Dates; Total and Original Contract Amounts; Currency; Tax Code; Contract Overview; Supplier Catalog; Supplier Catalog Discount Percentage; Supplier
     * Invoice Company; Supplier Invoice Payment Terms; Override Payment Type; Purchase Order Company; Purchase Order Issue Option; Purchase Order Payment Terms; Bill-To and Ship-To Contacts and Addresses; On Hold Flag; Submit Flag; Attachment Data; and
     * Supplier Contract Line Data. The Supplier Contract Line Data includes the Line Number, Company, Item, Item Description, Item Spend Category, Tax Applicability, Tax Code, Quantity, Unit of Measure, Unit Cost, Extended Amount, Start and End Date, Memo,
     * Location, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Contract_RequestType $body
     * @return \StructType\Submit_Supplier_Contract_ResponseType|bool
     */
    public function Submit_Supplier_Contract(\StructType\Submit_Supplier_Contract_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Contract($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Prepaid_Spend_Amortization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will create the Prepaid Spend Amortization for referenced Supplier Invoice. The business process will also be initiated.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Prepaid_Spend_Amortization_RequestType $body
     * @return \StructType\Submit_Prepaid_Spend_Amortization_ResponseType|bool
     */
    public function Submit_Prepaid_Spend_Amortization(\StructType\Submit_Prepaid_Spend_Amortization_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Prepaid_Spend_Amortization($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Invoice_Schedule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Invoice Schedules to Supplier Contracts and submit to the Supplier Invoice Schedule business process. The Supplier Invoice data includes:Supplier Invoice Schedule ID; Submit;
     * Schedule Status; Company or Company Hierarchy; Supplier; Currency; Supplier Contract; Supplier Contract Lines; Schedule Description; On Hold Flag; Default Tax Code; Payment Terms; Override Payment Type; Auto-submit for Approval flag; Distribution
     * Method; Distribute by Quantity; Frequency Behavior; Schedule From Date; Schedule To Date; Number of Installments; Date Option; Day of Month; Automatically Regenerate Schedules; Automatically Submit Schedules and Supplier Invoice Installment Data.The
     * Supplier Invoice Installment Data includes:Supplier Invoice Installment ID; Supplier Invoice Installment; Installment Number; Installment Status; Installment (Invoice) Date; Installment Start(From) Date; Installment End(To) Date; Supplier Invoice
     * reference; On Hold Flag; Use Installment Overrides Flag; Override Tax Code; Override Payment Terms; Override Payment Type; Override Memo and Supplier Invoice Installment Line Data. The Supplier Invoice Installment Line Data includes:Supplier Contract
     * Line; Line Order; Use Line Overrides; Quantity; From Date; To Date; Amount; Override Unit Of Measure; Override Line Description; Override Spend Category and Override Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Invoice_Schedule_RequestType $body
     * @return \StructType\Submit_Supplier_Invoice_Schedule_ResponseType|bool
     */
    public function Submit_Supplier_Invoice_Schedule(\StructType\Submit_Supplier_Invoice_Schedule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Invoice_Schedule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Purchase_Order_Schedule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Invoice Schedules to Supplier Contracts and submit to the Supplier Invoice Schedule business process. The Purchase Order data includes:Purchase Order Schedule ID; Submit; Schedule
     * Status; Company or Company Hierarchy; Supplier; Currency; Supplier Contract; Supplier Contract Lines; Schedule Description; On Hold Flag; Buyer; Issue Option; Default Tax Code; Payment Terms; Auto-submit for Approval flag; Override Payment Type;
     * Procurement Card; Bill-To Contact; Bill-To Address; Ship-To Contact; Ship-To Address; Distribution Method; Frequency Behavior; Schedule From Date; Schedule To Date; Number of Installments; Date Option; Day of Month; Automatically Regenerate
     * Schedules; Automatically Submit Schedules and Purchase Order Installment Data.The Purchase Order Installment Data includes:Purchase Order Installment ID; Purchase Order Installment; Installment Number; Installment Status; Installment (Purchase Order)
     * Date; Installment Start(From) Date; Installment End(To) Date; Purchase Order reference; On Hold Flag; Use Installment Overrides Flag; Override Buyer; Override Tax Code; Override Purchase Order Issue Option; Override Payment Terms; Override Bill-To
     * Contact; Override Bill-To Address; Override Ship-To Contact; Override Ship-To Address; Override Payment Type; Override Procurement Card; Override Memo and Purchase Order Installment Line Data. The Purchase Order Installment Line Data
     * includes:Supplier Contract Line; Line Order; Use Line Overrides; Quantity; From Date; To Date; Amount; Override Unit Of Measure; Override Line Description; Override Spend Category and Override Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Purchase_Order_Schedule_RequestType $body
     * @return \StructType\Submit_Purchase_Order_Schedule_ResponseType|bool
     */
    public function Submit_Purchase_Order_Schedule(\StructType\Submit_Purchase_Order_Schedule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Purchase_Order_Schedule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Prepaid_Spend_Amortization_Schedule
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This creates custom schedules for prepaid spend amortizations. You must enter a reference to a supplier invoice or prepaid spend amortization schedule prior to running this task. You can create a prepaid spend amortization schedule
     * for the supplier invoice using the Create Prepaid Spend Amortization Schedule task or the Submit Supplier Invoice web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType $body
     * @return \StructType\Submit_Prepaid_Spend_Amortization_Schedule_ResponseType|bool
     */
    public function Submit_Prepaid_Spend_Amortization_Schedule(\StructType\Submit_Prepaid_Spend_Amortization_Schedule_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Prepaid_Spend_Amortization_Schedule($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates the Supplier and submit to the Supplier business process or Supplier Change business process for existing, approved suppliers. To prevent data loss, you must populate all fields for this web service operation.
     * Supplier data includes: Supplier ID, Supplier Reference ID, Supplier Name, Worktag Only, Approval Status, Submit Flag, Tax Authority Form Type, IRS 1099 Supplier Flag, Report 1099 with Parent Flag, TIN Type Reference, Supplier Category, Supplier
     * Group, Tax Document Date, Default Tax Code Reference, Certificate of Insurance Date, Customer Account Number, DUNS Number, Disable Change Order Flag, Purchase Order Issue Option, Payment Terms, Payment Types accepted, Default Payment Type,
     * Procurement Credit Card, Included Children, Proposed Children Reference, Business Entity data, Settlement Account data, Do Not Pay if Settlement Bank Account Change In Progress flag, Supplier Status, Proposed Supplier Status, Separate Payments flag,
     * Memo, Business Entity Alternate Name data, Business Entity Attachment data, and Areas Change Flags. Business Entity data includes Name, Tax ID, External ID, Contact Information data, and Business Entity Logo. Contact Information data includes
     * Address, Phone, Email, Instant Messenger, and Web Address data.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_RequestRootType $body
     * @return \StructType\Submit_Supplier_ResponseType|bool
     */
    public function Submit_Supplier(\StructType\Submit_Supplier_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Return
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add Returns and submit to the Return business process. Return Data includes Return ID, Return Reason, Return Date, Supplier Invoice, Supplier RMA, Memo, Attachment Data, and Return Line. For Return Line
     * there is a reference to a Purchase Order Item Line or a Supplier Contract Item Line (One is required, but can have both), Quantity to Return, and Memo. The Lines you are return must all be for the same Purchase Order or Supplier Contract.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Return_RequestType $body
     * @return \StructType\Submit_Return_ResponseType|bool
     */
    public function Submit_Return(\StructType\Submit_Return_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Return($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Workday_Project_Hierarchy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Submit Workday Project HierarchyNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Workday_Project_Hierarchy_RequestType $body
     * @return \StructType\Submit_Workday_Project_Hierarchy_ResponseType|bool
     */
    public function Submit_Workday_Project_Hierarchy(\StructType\Submit_Workday_Project_Hierarchy_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Workday_Project_Hierarchy($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Procurement_Card_Transaction_Verification
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will add or update a Procurement Card Transaction Verification and submit it to the business process. Procurement Card Transaction Verifications are used to verify Credit Card Transactions and may specify a Purchase
     * Order or Supplier Contract.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType $body
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_ResponseType|bool
     */
    public function Submit_Procurement_Card_Transaction_Verification(\StructType\Submit_Procurement_Card_Transaction_Verification_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Procurement_Card_Transaction_Verification($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Procurement_Mass_Close
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add a Procurement Mass Close request for specified Company or Company Hierarchy and Procurement Document Type, and submit it to the business process. Procurement Mass Close Data includes Company or Company
     * Hierarchy, Procurement Document Type, Procurement Mass Close Request Name, and Memo. Procurement Mass Close Line Data includes the Business Document to be closed that matches the Procurement Document Type specified, a Memo and option to Exclude from
     * Process.Only creation of a new Procurement Mass Close request can be made through this service operation.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Procurement_Mass_Close_RequestType $body
     * @return \StructType\Submit_Procurement_Mass_Close_ResponseType|bool
     */
    public function Submit_Procurement_Mass_Close(\StructType\Submit_Procurement_Mass_Close_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Procurement_Mass_Close($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Project
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This WWS will create a Project Event and submit it through workflow for approval. Once approved, the actual Project will be created. A project can be used as a worktag throughout Financial Management and HCM. This operation is for
     * Project Data only. Project Resource plans and project plans will be handled by other web service operations.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Project_RequestType $body
     * @return \StructType\Submit_Project_ResponseType|bool
     */
    public function Submit_Project(\StructType\Submit_Project_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Project($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Resource_Plan
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is W23 Submit Project Resource Plan web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Resource_Plan_RequestType $body
     * @return \StructType\Submit_Resource_Plan_ResponseType|bool
     */
    public function Submit_Resource_Plan(\StructType\Submit_Resource_Plan_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Resource_Plan($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Request_for_Quote
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation can create a Request for Quote Document and submit it to the business process. It can also modify an existing Request for Quote Document in Draft status. The Request for Quote document can have Goods and Service Lines,
     * Bid requirements and proposed Suppliers. Each of the lines can its own bid requirements and line split details.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Request_for_Quote_RequestType $body
     * @return \StructType\Submit_Request_for_Quote_ResponseType|bool
     */
    public function Submit_Request_for_Quote(\StructType\Submit_Request_for_Quote_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Request_for_Quote($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Request_for_Quote_Response
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation can create a RFQ Response Document and submit it to the business process. It can also modify an existing RFQ Response Document in Draft status. A RFQ Response document contains responses to the original RFQ Line and
     * its related bid requirements.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Request_for_Quote_Response_RequestType $body
     * @return \StructType\Submit_Request_for_Quote_Response_ResponseType|bool
     */
    public function Submit_Request_for_Quote_Response(\StructType\Submit_Request_for_Quote_Response_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Request_for_Quote_Response($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Remit_To_Supplier_Connection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Connection and submit to the Supplier Connection Event business process. Supplier Connection data includes owning Supplier, Supplier Connection ID, Supplier Connection Name, Remit To
     * Supplier Reference, Default Payment Type, Accepted Payment Type, Settlement Bank Account Reference, Remit To Address Reference, Remit To Email, Payee Alternate Name Reference, Payment Memo, Default flag and inactive flag.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Remit_To_Supplier_Connection_RequestRootType $body
     * @return \StructType\Submit_Remit_To_Supplier_Connection_ResponseType|bool
     */
    public function Submit_Remit_To_Supplier_Connection(\StructType\Submit_Remit_To_Supplier_Connection_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Remit_To_Supplier_Connection($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Request_for_Quote_Award
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation can create a RFQ Award Document and submit it to the business process. A Purchase Order or Supplier Contract is created once the award document is approved. This webservice can also be used to modify an existing RFQ
     * Award Document in Draft status.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Request_for_Quote_Award_RequestType $body
     * @return \StructType\Submit_Request_for_Quote_Award_ResponseType|bool
     */
    public function Submit_Request_for_Quote_Award(\StructType\Submit_Request_for_Quote_Award_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Request_for_Quote_Award($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Supplier_Contact_Information
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will replace all existing Supplier Contact Information and submit to the Supplier Contact Information Change Event business process. This will include deleting (after full approval) all existing Supplier
     * Contact Information for the Supplier and replacing it with data provided by the service operation. Exception: If an Address Reference is provided, existing Address matching that Reference will be updated. The Supplier must be in Approved state to use
     * this web service. Supplier Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data. If no data is provided all existing data will be removed (subject to business process approval).No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Contact_Information_RequestType $body
     * @return \StructType\Submit_Supplier_Contact_Information_ResponseType|bool
     */
    public function Submit_Supplier_Contact_Information(\StructType\Submit_Supplier_Contact_Information_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Contact_Information($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Purchase_Order_Change_Order
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will make modification on the header, line, split levels of an issued Purchase Order. Contingent Worker and project-based services are not supported in this version of the web service. Certain limitations will
     * prevent the changes of some data, especially for objects that are sensitive to accounting records.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Purchase_Order_Change_Order_RequestType $body
     * @return \StructType\Submit_Purchase_Order_Change_Order_ResponseType|bool
     */
    public function Submit_Purchase_Order_Change_Order(\StructType\Submit_Purchase_Order_Change_Order_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Purchase_Order_Change_Order($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Expense_Report_for_Non-Worker
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Expense Reports for ~Non-Workers~ and submit them to the Expense Report Event Business Process. Expense Report data includes Date, Business Purpose, Total Amount, Payment Type, Memo, and
     * Expense Report Lines. The data for the lines includes Date, Quantity, Amount, Expense Item, Conversion Rate, Converted Amount, Expense Item Attributes, Memo, Flags for Billable and Receipt Included, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Expense_Report_for_Non_Worker_RequestType $body
     * @return \StructType\Submit_Expense_Report_for_Non_Worker_ResponseType|bool
     */
    public function Submit_Expense_Report_for_Non_Worker(\StructType\Submit_Expense_Report_for_Non_Worker_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Submit_Expense_Report_for_Non-Worker', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Internal_Service_Delivery
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to create an Internal Service Delivery document and submit into the Business Process. It can also be used to edit an existing Internal Service Delivery that is in Draft or In-Progress status.
     * The Internal Service Delivery document must include at least one line (with or without splits) and may or may not include attachments.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Internal_Service_Delivery_RequestType $body
     * @return \StructType\Submit_Internal_Service_Delivery_ResponseType|bool
     */
    public function Submit_Internal_Service_Delivery(\StructType\Submit_Internal_Service_Delivery_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Internal_Service_Delivery($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Invoice_Request
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation can be used to create a Supplier Invoice Request and submit into the Business Process. It can also be used to edit an existing Supplier Invoice Request that is in Draft or In-Progress status. The Supplier
     * Invoice Request must include at least one line (with or without splits) and may or may not include attachments.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Invoice_Request_RequestType $body
     * @return \StructType\Submit_Supplier_Invoice_Request_ResponseType|bool
     */
    public function Submit_Supplier_Invoice_Request(\StructType\Submit_Supplier_Invoice_Request_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Invoice_Request($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Advanced_Ship_Notice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation can create a Advance Shipment Notice and submit it to the business process. It can also modify an existing Advance Shipment Notice in Draft status.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Advanced_Ship_Notice_RequestType $body
     * @return \StructType\Submit_Advanced_Ship_Notice_ResponseType|bool
     */
    public function Submit_Advanced_Ship_Notice(\StructType\Submit_Advanced_Ship_Notice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Advanced_Ship_Notice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Purchase_Order_Acknowledgement
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add a Purchase Order Acknowledgement for a Purchase Order. Purchase Order Acknowledgement data includes a Purchase Order Reference, Memo, Purchase Order Acknowledgement Line Data and Attachment Data.
     * Purchase Order Acknowledgements can only be created for goods lines. Purchase Order Acknowledgements for Service Delivery and Contingent Worker Purchase Orders are not supported in this web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Purchase_Order_Acknowledgement_RequestType $body
     * @return \StructType\Submit_Purchase_Order_Acknowledgement_ResponseType|bool
     */
    public function Submit_Purchase_Order_Acknowledgement(\StructType\Submit_Purchase_Order_Acknowledgement_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Purchase_Order_Acknowledgement($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Mass_Reopen_Procurement_Documents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add a Mass Reopen Procurement Document request for specified Company or Company Hierarchy and Procurement Document Type, and submit it to the business process. Mass Reopen Procurement Documents Data
     * includes Company or Company Hierarchy, Procurement Document Type, Mass Reopen Procurement Documents Request Name, and Memo. Mass Reopen Procurement Documents Data includes the Business Document to be closed that matches the Procurement Document Type
     * specified.Only creation of a new Mass Reopen Procurement Document request can be made through this service operation.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Mass_Reopen_Procurement_Documents_RequestType $body
     * @return \StructType\Submit_Mass_Reopen_Procurement_Documents_ResponseType|bool
     */
    public function Submit_Mass_Reopen_Procurement_Documents(\StructType\Submit_Mass_Reopen_Procurement_Documents_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Mass_Reopen_Procurement_Documents($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Order_From_Supplier_Connection
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Order-From Supplier Connection and submit to the Supplier Connection Event business process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Order_From_Supplier_Connection_RequestType $body
     * @return \StructType\Submit_Order_From_Supplier_Connection_ResponseType|bool
     */
    public function Submit_Order_From_Supplier_Connection(\StructType\Submit_Order_From_Supplier_Connection_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Order_From_Supplier_Connection($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Contract_Amendment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Amends supplier contracts and supports changes to the header and lines.Workday prevents changes to objects that have sensitive accounting records. If an existing line is modified it will be fully replaced by the submitted data (if
     * allowed). The following are not supported: Project-based service lines Lease Contracts Add Contract Line Hold amendment type Remove Contract Line Hold amendment typeNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Contract_Amendment_RequestType $body
     * @return \StructType\Submit_Supplier_Contract_Amendment_ResponseType|bool
     */
    public function Submit_Supplier_Contract_Amendment(\StructType\Submit_Supplier_Contract_Amendment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Contract_Amendment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Submit_Supplier_Contract_Lease_Amendment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates lease amendments for supplier contracts. Updates require a full replace of the customer’s data. Uses the Supplier Contract Amendment Event business process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Contract_Lease_Amendment_RequestType $body
     * @return \StructType\Submit_Supplier_Contract_Lease_Amendment_ResponseType|bool
     */
    public function Submit_Supplier_Contract_Lease_Amendment(\StructType\Submit_Supplier_Contract_Lease_Amendment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Contract_Lease_Amendment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Receipt_Adjustment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Create Receipt Adjustment for Eligible ReceiptNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Receipt_Adjustment_RequestType $body
     * @return \StructType\Submit_Receipt_Adjustment_ResponseType|bool
     */
    public function Submit_Receipt_Adjustment(\StructType\Submit_Receipt_Adjustment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Receipt_Adjustment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Netting_Transaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add Netting Transaction and submit to the Netting Transaction business process. Netting Transaction Data includes Submit Flag, Company, Currency, Netting Rule, Netting Transaction Date, Supplier Invoice
     * Date On or After Date, Supplier Invoice Date On or Before Date, Customer Invoice Date On or After Date, Customer Invoice Date On or Before Date, Attachment, Supplier Invoice for Netting Data, and Customer Invoice for Netting Data. Supplier Invoice
     * for Netting Data includes Supplier Invoice Reference or Supplier Invoice Adjustment Reference and Amount to Net. Customer Invoice for Netting Data includes Customer Invoice Reference or Customer Invoice Adjustment Reference and Amount to Net.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Netting_Transaction_RequestType $body
     * @return \StructType\Submit_Netting_Transaction_ResponseType|bool
     */
    public function Submit_Netting_Transaction(\StructType\Submit_Netting_Transaction_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Netting_Transaction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Submit_Supplier_Refund
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Supplier Refunds and submit to the Supplier Refund business process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Submit_Supplier_Refund_RequestType $body
     * @return \StructType\Submit_Supplier_Refund_ResponseType|bool
     */
    public function Submit_Supplier_Refund(\StructType\Submit_Supplier_Refund_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Submit_Supplier_Refund($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Submit_Advanced_Ship_Notice_ResponseType|\StructType\Submit_Catalog_Load_ResponseType|\StructType\Submit_Expense_Report_for_Applicant_ResponseType|\StructType\Submit_Expense_Report_for_Non_Worker_ResponseType|\StructType\Submit_Expense_Report_ResponseType|\StructType\Submit_Internal_Service_Delivery_ResponseType|\StructType\Submit_Mass_Reopen_Procurement_Documents_ResponseType|\StructType\Submit_Netting_Transaction_ResponseType|\StructType\Submit_Order_From_Supplier_Connection_ResponseType|\StructType\Submit_Prepaid_Spend_Amortization_ResponseType|\StructType\Submit_Prepaid_Spend_Amortization_Schedule_ResponseType|\StructType\Submit_Procurement_Card_Transaction_Verification_ResponseType|\StructType\Submit_Procurement_Mass_Close_ResponseType|\StructType\Submit_Project_ResponseType|\StructType\Submit_Purchase_Order_Acknowledgement_ResponseType|\StructType\Submit_Purchase_Order_Change_Order_ResponseType|\StructType\Submit_Purchase_Order_ResponseType|\StructType\Submit_Purchase_Order_Schedule_ResponseType|\StructType\Submit_Receipt_Adjustment_ResponseType|\StructType\Submit_Receipt_ResponseType|\StructType\Submit_Remit_To_Supplier_Connection_ResponseType|\StructType\Submit_Request_for_Quote_Award_ResponseType|\StructType\Submit_Request_for_Quote_ResponseType|\StructType\Submit_Request_for_Quote_Response_ResponseType|\StructType\Submit_Requisition_ResponseType|\StructType\Submit_Resource_Plan_ResponseType|\StructType\Submit_Return_ResponseType|\StructType\Submit_Spend_Authorization_ResponseType|\StructType\Submit_Supplier_Contact_Information_ResponseType|\StructType\Submit_Supplier_Contract_Amendment_ResponseType|\StructType\Submit_Supplier_Contract_Lease_Amendment_ResponseType|\StructType\Submit_Supplier_Contract_ResponseType|\StructType\Submit_Supplier_Invoice_Adjustment_ResponseType|\StructType\Submit_Supplier_Invoice_Contract_ResponseType|\StructType\Submit_Supplier_Invoice_Request_ResponseType|\StructType\Submit_Supplier_Invoice_ResponseType|\StructType\Submit_Supplier_Invoice_Schedule_ResponseType|\StructType\Submit_Supplier_Order_Contract_ResponseType|\StructType\Submit_Supplier_Refund_ResponseType|\StructType\Submit_Supplier_ResponseType|\StructType\Submit_Workday_Project_Hierarchy_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
