<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_InvoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Instance and Data
 * @subpackage Structs
 */
class Supplier_InvoiceType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Supplier_Invoice_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DataType[]
     */
    public $Supplier_Invoice_Data;
    /**
     * Constructor method for Supplier_InvoiceType
     * @uses Supplier_InvoiceType::setSupplier_Invoice_Reference()
     * @uses Supplier_InvoiceType::setSupplier_Invoice_Data()
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param \StructType\Supplier_Invoice_DataType[] $supplier_Invoice_Data
     */
    public function __construct(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, array $supplier_Invoice_Data = array())
    {
        $this
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setSupplier_Invoice_Data($supplier_Invoice_Data);
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Supplier_InvoiceType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Data value
     * @return \StructType\Supplier_Invoice_DataType[]|null
     */
    public function getSupplier_Invoice_Data()
    {
        return $this->Supplier_Invoice_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_DataForArrayConstraintsFromSetSupplier_Invoice_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_InvoiceTypeSupplier_Invoice_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_InvoiceTypeSupplier_Invoice_DataItem instanceof \StructType\Supplier_Invoice_DataType) {
                $invalidValues[] = is_object($supplier_InvoiceTypeSupplier_Invoice_DataItem) ? get_class($supplier_InvoiceTypeSupplier_Invoice_DataItem) : sprintf('%s(%s)', gettype($supplier_InvoiceTypeSupplier_Invoice_DataItem), var_export($supplier_InvoiceTypeSupplier_Invoice_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Data property can only contain items of type \StructType\Supplier_Invoice_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_DataType[] $supplier_Invoice_Data
     * @return \StructType\Supplier_InvoiceType
     */
    public function setSupplier_Invoice_Data(array $supplier_Invoice_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_DataArrayErrorMessage = self::validateSupplier_Invoice_DataForArrayConstraintsFromSetSupplier_Invoice_Data($supplier_Invoice_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Data = $supplier_Invoice_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_DataType $item
     * @return \StructType\Supplier_InvoiceType
     */
    public function addToSupplier_Invoice_Data(\StructType\Supplier_Invoice_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Data property can only contain items of type \StructType\Supplier_Invoice_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Data[] = $item;
        return $this;
    }
}
