<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Classification Widget Element to include Supplier Classification Interface WSS Data element
 * @subpackage Structs
 */
class Supplier_Classification_Widget_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Classification_Interface_WWS_DataType[]
     */
    public $Supplier_Classification_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Replace All boolean to replace (True) or update (False) Supplier Classification Information
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Supplier_Classification_Widget_DataType
     * @uses Supplier_Classification_Widget_DataType::setSupplier_Classification_Data()
     * @uses Supplier_Classification_Widget_DataType::setReplace_All()
     * @param \StructType\Supplier_Classification_Interface_WWS_DataType[] $supplier_Classification_Data
     * @param bool $replace_All
     */
    public function __construct(array $supplier_Classification_Data = array(), $replace_All = null)
    {
        $this
            ->setSupplier_Classification_Data($supplier_Classification_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Supplier_Classification_Data value
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType[]|null
     */
    public function getSupplier_Classification_Data()
    {
        return $this->Supplier_Classification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_DataForArrayConstraintsFromSetSupplier_Classification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem instanceof \StructType\Supplier_Classification_Interface_WWS_DataType) {
                $invalidValues[] = is_object($supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem) ? get_class($supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem) : sprintf('%s(%s)', gettype($supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem), var_export($supplier_Classification_Widget_DataTypeSupplier_Classification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Data property can only contain items of type \StructType\Supplier_Classification_Interface_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Interface_WWS_DataType[] $supplier_Classification_Data
     * @return \StructType\Supplier_Classification_Widget_DataType
     */
    public function setSupplier_Classification_Data(array $supplier_Classification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_DataArrayErrorMessage = self::validateSupplier_Classification_DataForArrayConstraintsFromSetSupplier_Classification_Data($supplier_Classification_Data))) {
            throw new \InvalidArgumentException($supplier_Classification_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Data = $supplier_Classification_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Interface_WWS_DataType $item
     * @return \StructType\Supplier_Classification_Widget_DataType
     */
    public function addToSupplier_Classification_Data(\StructType\Supplier_Classification_Interface_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Classification_Interface_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Data property can only contain items of type \StructType\Supplier_Classification_Interface_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Supplier_Classification_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
