<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Distance-based expense item attributes can't be used with this web service. | Spend Authorization Line: Invalid unit cost for fixed amount Expense Item. Unit Cost cannot be changed. | Spend Authorization Line: Invalid unit cost for
 * Expense Item. Unit Cost is greater then maximum allowed amount. View the Expense Item details for maximum amount allowed. | The Expense Item Details Reference Element is required for the expense item. | Quantity is required for the expense item. |
 * Unit Cost is required for non-fixed expense items and fixed expense items that does not use expense rate tables. | Unit Cost is not enterable for fixed expense items that use expense rate tables. | Only one worktag for each type is allowed for each
 * document line. | Cash advances are not enabled in your tenant. | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Element that encapsulates all data for one Spend Authorization Line (Expense Item,
 * Quantity, Unit Cost, Billable flag, Worktags, and Memo).
 * @subpackage Structs
 */
class Spend_Authorization_Line_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Expense Item for the Spend Authorization Line.
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Expense_Item_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not the expense is billable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Cash_Advance_Requested
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not the expense is a cash advance. This field is only available if cash advances are enabled for the tenant.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Cash_Advance_Requested;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Text describing the use or purpose of the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Line Budget Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Expense_Item_Details_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Expense_Report_Line_Detail_DataType
     */
    public $Expense_Item_Details_Data;
    /**
     * Constructor method for Spend_Authorization_Line_DataType
     * @uses Spend_Authorization_Line_DataType::setExpense_Item_Reference()
     * @uses Spend_Authorization_Line_DataType::setQuantity()
     * @uses Spend_Authorization_Line_DataType::setUnit_Cost()
     * @uses Spend_Authorization_Line_DataType::setBillable()
     * @uses Spend_Authorization_Line_DataType::setCash_Advance_Requested()
     * @uses Spend_Authorization_Line_DataType::setWorktag_Reference()
     * @uses Spend_Authorization_Line_DataType::setMemo()
     * @uses Spend_Authorization_Line_DataType::setBudget_Date()
     * @uses Spend_Authorization_Line_DataType::setExpense_Item_Details_Data()
     * @param \StructType\Item_DescriptorObjectType $expense_Item_Reference
     * @param float $quantity
     * @param float $unit_Cost
     * @param bool $billable
     * @param bool $cash_Advance_Requested
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $memo
     * @param string $budget_Date
     * @param \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data
     */
    public function __construct(\StructType\Item_DescriptorObjectType $expense_Item_Reference = null, $quantity = null, $unit_Cost = null, $billable = null, $cash_Advance_Requested = null, array $worktag_Reference = array(), $memo = null, $budget_Date = null, \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data = null)
    {
        $this
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setQuantity($quantity)
            ->setUnit_Cost($unit_Cost)
            ->setBillable($billable)
            ->setCash_Advance_Requested($cash_Advance_Requested)
            ->setWorktag_Reference($worktag_Reference)
            ->setMemo($memo)
            ->setBudget_Date($budget_Date)
            ->setExpense_Item_Details_Data($expense_Item_Details_Data);
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * Set Expense_Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $expense_Item_Reference
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setExpense_Item_Reference(\StructType\Item_DescriptorObjectType $expense_Item_Reference = null)
    {
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Cash_Advance_Requested value
     * @return bool|null
     */
    public function getCash_Advance_Requested()
    {
        return $this->Cash_Advance_Requested;
    }
    /**
     * Set Cash_Advance_Requested value
     * @param bool $cash_Advance_Requested
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setCash_Advance_Requested($cash_Advance_Requested = null)
    {
        // validation for constraint: boolean
        if (!is_null($cash_Advance_Requested) && !is_bool($cash_Advance_Requested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cash_Advance_Requested, true), gettype($cash_Advance_Requested)), __LINE__);
        }
        $this->Cash_Advance_Requested = $cash_Advance_Requested;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($spend_Authorization_Line_DataTypeWorktag_ReferenceItem) ? get_class($spend_Authorization_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Authorization_Line_DataTypeWorktag_ReferenceItem), var_export($spend_Authorization_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Expense_Item_Details_Data value
     * @return \StructType\Expense_Report_Line_Detail_DataType|null
     */
    public function getExpense_Item_Details_Data()
    {
        return $this->Expense_Item_Details_Data;
    }
    /**
     * Set Expense_Item_Details_Data value
     * @param \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data
     * @return \StructType\Spend_Authorization_Line_DataType
     */
    public function setExpense_Item_Details_Data(\StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data = null)
    {
        $this->Expense_Item_Details_Data = $expense_Item_Details_Data;
        return $this;
    }
}
