<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_Data_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of the entire Internal Service Delivery, including Lines (with and without splits) and Attachments.
 * @subpackage Structs
 */
class Internal_Service_Delivery_Data_OutboundType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Delivery_ID;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: A unique Workday system generated Internal Service Delivery Number. This value cannot be updated, but it can be used to reference the instance of the Internal Service Delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on the Internal Service Delivery.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Provider that is supplying the services referenced on the Internal Service Delivery.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency on the Internal Service Delivery.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date on the Internal Service Delivery. This is the date used to generate accounting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Default Service Date on the Internal Service Delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delivery_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo on the Internal Service Delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of the Internal Service Delivery.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Approved_On_Date
     * Meta information extracted from the WSDL
     * - documentation: Date on which the Internal Service Delivery was approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_On_Date;
    /**
     * The Intercompany_Internal_Service_Delivery
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Internal Service Delivery is Intercompany or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Intercompany_Internal_Service_Delivery;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Internal_Service_Delivery_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents Internal Service Delivery Line information. A Internal Service Delivery may have multiple lines, with or without Splits.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_Line_Data_OutboundType[]
     */
    public $Internal_Service_Delivery_Line_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Element contains attachments for business document.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * Constructor method for Internal_Service_Delivery_Data_OutboundType
     * @uses Internal_Service_Delivery_Data_OutboundType::setInternal_Service_Delivery_ID()
     * @uses Internal_Service_Delivery_Data_OutboundType::setDocument_Number()
     * @uses Internal_Service_Delivery_Data_OutboundType::setCompany_Reference()
     * @uses Internal_Service_Delivery_Data_OutboundType::setInternal_Service_Provider_Reference()
     * @uses Internal_Service_Delivery_Data_OutboundType::setCurrency_Reference()
     * @uses Internal_Service_Delivery_Data_OutboundType::setDocument_Date()
     * @uses Internal_Service_Delivery_Data_OutboundType::setDelivery_Date()
     * @uses Internal_Service_Delivery_Data_OutboundType::setMemo()
     * @uses Internal_Service_Delivery_Data_OutboundType::setDocument_Status_Reference()
     * @uses Internal_Service_Delivery_Data_OutboundType::setApproved_On_Date()
     * @uses Internal_Service_Delivery_Data_OutboundType::setIntercompany_Internal_Service_Delivery()
     * @uses Internal_Service_Delivery_Data_OutboundType::setWorktags_Reference()
     * @uses Internal_Service_Delivery_Data_OutboundType::setInternal_Service_Delivery_Line_Data()
     * @uses Internal_Service_Delivery_Data_OutboundType::setBusiness_Document_Attachment_Data()
     * @param string $internal_Service_Delivery_ID
     * @param string $document_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $document_Date
     * @param string $delivery_Date
     * @param string $memo
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param string $approved_On_Date
     * @param bool $intercompany_Internal_Service_Delivery
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Internal_Service_Delivery_Line_Data_OutboundType[] $internal_Service_Delivery_Line_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     */
    public function __construct($internal_Service_Delivery_ID = null, $document_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $document_Date = null, $delivery_Date = null, $memo = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, $approved_On_Date = null, $intercompany_Internal_Service_Delivery = null, array $worktags_Reference = array(), array $internal_Service_Delivery_Line_Data = array(), array $business_Document_Attachment_Data = array())
    {
        $this
            ->setInternal_Service_Delivery_ID($internal_Service_Delivery_ID)
            ->setDocument_Number($document_Number)
            ->setCompany_Reference($company_Reference)
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setDocument_Date($document_Date)
            ->setDelivery_Date($delivery_Date)
            ->setMemo($memo)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setApproved_On_Date($approved_On_Date)
            ->setIntercompany_Internal_Service_Delivery($intercompany_Internal_Service_Delivery)
            ->setWorktags_Reference($worktags_Reference)
            ->setInternal_Service_Delivery_Line_Data($internal_Service_Delivery_Line_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data);
    }
    /**
     * Get Internal_Service_Delivery_ID value
     * @return string|null
     */
    public function getInternal_Service_Delivery_ID()
    {
        return $this->Internal_Service_Delivery_ID;
    }
    /**
     * Set Internal_Service_Delivery_ID value
     * @param string $internal_Service_Delivery_ID
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setInternal_Service_Delivery_ID($internal_Service_Delivery_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Delivery_ID) && !is_string($internal_Service_Delivery_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Delivery_ID, true), gettype($internal_Service_Delivery_ID)), __LINE__);
        }
        $this->Internal_Service_Delivery_ID = $internal_Service_Delivery_ID;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Delivery_Date value
     * @return string|null
     */
    public function getDelivery_Date()
    {
        return $this->Delivery_Date;
    }
    /**
     * Set Delivery_Date value
     * @param string $delivery_Date
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setDelivery_Date($delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($delivery_Date) && !is_string($delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery_Date, true), gettype($delivery_Date)), __LINE__);
        }
        $this->Delivery_Date = $delivery_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Approved_On_Date value
     * @return string|null
     */
    public function getApproved_On_Date()
    {
        return $this->Approved_On_Date;
    }
    /**
     * Set Approved_On_Date value
     * @param string $approved_On_Date
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setApproved_On_Date($approved_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_On_Date) && !is_string($approved_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_On_Date, true), gettype($approved_On_Date)), __LINE__);
        }
        $this->Approved_On_Date = $approved_On_Date;
        return $this;
    }
    /**
     * Get Intercompany_Internal_Service_Delivery value
     * @return bool|null
     */
    public function getIntercompany_Internal_Service_Delivery()
    {
        return $this->Intercompany_Internal_Service_Delivery;
    }
    /**
     * Set Intercompany_Internal_Service_Delivery value
     * @param bool $intercompany_Internal_Service_Delivery
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setIntercompany_Internal_Service_Delivery($intercompany_Internal_Service_Delivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($intercompany_Internal_Service_Delivery) && !is_bool($intercompany_Internal_Service_Delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intercompany_Internal_Service_Delivery, true), gettype($intercompany_Internal_Service_Delivery)), __LINE__);
        }
        $this->Intercompany_Internal_Service_Delivery = $intercompany_Internal_Service_Delivery;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem) ? get_class($internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem), var_export($internal_Service_Delivery_Data_OutboundTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Line_Data value
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType[]|null
     */
    public function getInternal_Service_Delivery_Line_Data()
    {
        return $this->Internal_Service_Delivery_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Delivery_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Delivery_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Delivery_Line_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem instanceof \StructType\Internal_Service_Delivery_Line_Data_OutboundType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem) ? get_class($internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem), var_export($internal_Service_Delivery_Data_OutboundTypeInternal_Service_Delivery_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Delivery_Line_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Delivery_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Data_OutboundType[] $internal_Service_Delivery_Line_Data
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setInternal_Service_Delivery_Line_Data(array $internal_Service_Delivery_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Delivery_Line_DataArrayErrorMessage = self::validateInternal_Service_Delivery_Line_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Data($internal_Service_Delivery_Line_Data))) {
            throw new \InvalidArgumentException($internal_Service_Delivery_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Data = $internal_Service_Delivery_Line_Data;
        return $this;
    }
    /**
     * Add item to Internal_Service_Delivery_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Data_OutboundType $item
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function addToInternal_Service_Delivery_Line_Data(\StructType\Internal_Service_Delivery_Line_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Delivery_Line_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Delivery_Line_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem) ? get_class($internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem), var_export($internal_Service_Delivery_Data_OutboundTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
}
