<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Group_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Expense Item Group Instance and Data
 * @subpackage Structs
 */
class Expense_Item_Group_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_Group
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_GroupType[]
     */
    public $Expense_Item_Group;
    /**
     * Constructor method for Expense_Item_Group_Response_DataType
     * @uses Expense_Item_Group_Response_DataType::setExpense_Item_Group()
     * @param \StructType\Expense_Item_GroupType[] $expense_Item_Group
     */
    public function __construct(array $expense_Item_Group = array())
    {
        $this
            ->setExpense_Item_Group($expense_Item_Group);
    }
    /**
     * Get Expense_Item_Group value
     * @return \StructType\Expense_Item_GroupType[]|null
     */
    public function getExpense_Item_Group()
    {
        return $this->Expense_Item_Group;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_GroupForArrayConstraintsFromSetExpense_Item_Group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Group_Response_DataTypeExpense_Item_GroupItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Group_Response_DataTypeExpense_Item_GroupItem instanceof \StructType\Expense_Item_GroupType) {
                $invalidValues[] = is_object($expense_Item_Group_Response_DataTypeExpense_Item_GroupItem) ? get_class($expense_Item_Group_Response_DataTypeExpense_Item_GroupItem) : sprintf('%s(%s)', gettype($expense_Item_Group_Response_DataTypeExpense_Item_GroupItem), var_export($expense_Item_Group_Response_DataTypeExpense_Item_GroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Group property can only contain items of type \StructType\Expense_Item_GroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_GroupType[] $expense_Item_Group
     * @return \StructType\Expense_Item_Group_Response_DataType
     */
    public function setExpense_Item_Group(array $expense_Item_Group = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_GroupArrayErrorMessage = self::validateExpense_Item_GroupForArrayConstraintsFromSetExpense_Item_Group($expense_Item_Group))) {
            throw new \InvalidArgumentException($expense_Item_GroupArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Group = $expense_Item_Group;
        return $this;
    }
    /**
     * Add item to Expense_Item_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_GroupType $item
     * @return \StructType\Expense_Item_Group_Response_DataType
     */
    public function addToExpense_Item_Group(\StructType\Expense_Item_GroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_GroupType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Group property can only contain items of type \StructType\Expense_Item_GroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Group[] = $item;
        return $this;
    }
}
