<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cash_Advance_Repayment_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cash Advance Repayment Reference element contains the specific Cash Advance Repayment requested. The ID is the value and the Type attribute is either the Lookup ID type or the Workday ID (GUID) for the reference to the Cash Advance
 * Repayment.
 * @subpackage Structs
 */
class Cash_Advance_Repayment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Cash_Advance_Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Object containing the Cash Advance Repayment
     * - maxOccurs: unbounded
     * @var \StructType\Cash_Advance_RepaymentObjectType[]
     */
    public $Cash_Advance_Repayment_Reference;
    /**
     * Constructor method for Cash_Advance_Repayment_Request_ReferencesType
     * @uses Cash_Advance_Repayment_Request_ReferencesType::setCash_Advance_Repayment_Reference()
     * @param \StructType\Cash_Advance_RepaymentObjectType[] $cash_Advance_Repayment_Reference
     */
    public function __construct(array $cash_Advance_Repayment_Reference = array())
    {
        $this
            ->setCash_Advance_Repayment_Reference($cash_Advance_Repayment_Reference);
    }
    /**
     * Get Cash_Advance_Repayment_Reference value
     * @return \StructType\Cash_Advance_RepaymentObjectType[]|null
     */
    public function getCash_Advance_Repayment_Reference()
    {
        return $this->Cash_Advance_Repayment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCash_Advance_Repayment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCash_Advance_Repayment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCash_Advance_Repayment_ReferenceForArrayConstraintsFromSetCash_Advance_Repayment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem instanceof \StructType\Cash_Advance_RepaymentObjectType) {
                $invalidValues[] = is_object($cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem) ? get_class($cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem) : sprintf('%s(%s)', gettype($cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem), var_export($cash_Advance_Repayment_Request_ReferencesTypeCash_Advance_Repayment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cash_Advance_Repayment_Reference property can only contain items of type \StructType\Cash_Advance_RepaymentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cash_Advance_Repayment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cash_Advance_RepaymentObjectType[] $cash_Advance_Repayment_Reference
     * @return \StructType\Cash_Advance_Repayment_Request_ReferencesType
     */
    public function setCash_Advance_Repayment_Reference(array $cash_Advance_Repayment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($cash_Advance_Repayment_ReferenceArrayErrorMessage = self::validateCash_Advance_Repayment_ReferenceForArrayConstraintsFromSetCash_Advance_Repayment_Reference($cash_Advance_Repayment_Reference))) {
            throw new \InvalidArgumentException($cash_Advance_Repayment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Cash_Advance_Repayment_Reference = $cash_Advance_Repayment_Reference;
        return $this;
    }
    /**
     * Add item to Cash_Advance_Repayment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Cash_Advance_RepaymentObjectType $item
     * @return \StructType\Cash_Advance_Repayment_Request_ReferencesType
     */
    public function addToCash_Advance_Repayment_Reference(\StructType\Cash_Advance_RepaymentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cash_Advance_RepaymentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Cash_Advance_Repayment_Reference property can only contain items of type \StructType\Cash_Advance_RepaymentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cash_Advance_Repayment_Reference[] = $item;
        return $this;
    }
}
