<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_Record_Name_Match_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking Record matches should only include 1 match of either an Origin City, Destination City, or Merchant (Hotel, Airline, or Car Rental Agency). | Confidence level percentage must between 0 and 100. | Travel Booking Record
 * Name Match must include either a Merchant, Origination City, or a Destination City. | Travel Booking Record Name Match Data.
 * @subpackage Structs
 */
class Travel_Booking_Record_Name_Match_DataType extends AbstractStructBase
{
    /**
     * The Travel_Booking_Record_Confidence_Percentage
     * Meta information extracted from the WSDL
     * - documentation: Confidence Percentage for Travel Booking Record match data.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Travel_Booking_Record_Confidence_Percentage;
    /**
     * The Origination_Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Origination City matching the origination city on the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Origination_Travel_City_Reference;
    /**
     * The Destination_Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Destination City matching the destination city on the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Destination_Travel_City_Reference;
    /**
     * The Merchant_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merchant matching the merchant listed on the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Merchant_Reference;
    /**
     * Constructor method for Travel_Booking_Record_Name_Match_DataType
     * @uses Travel_Booking_Record_Name_Match_DataType::setTravel_Booking_Record_Confidence_Percentage()
     * @uses Travel_Booking_Record_Name_Match_DataType::setOrigination_Travel_City_Reference()
     * @uses Travel_Booking_Record_Name_Match_DataType::setDestination_Travel_City_Reference()
     * @uses Travel_Booking_Record_Name_Match_DataType::setMerchant_Reference()
     * @param float $travel_Booking_Record_Confidence_Percentage
     * @param \StructType\Abstract_Spend_Data_NameObjectType $origination_Travel_City_Reference
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     */
    public function __construct($travel_Booking_Record_Confidence_Percentage = null, \StructType\Abstract_Spend_Data_NameObjectType $origination_Travel_City_Reference = null, \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference = null, \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null)
    {
        $this
            ->setTravel_Booking_Record_Confidence_Percentage($travel_Booking_Record_Confidence_Percentage)
            ->setOrigination_Travel_City_Reference($origination_Travel_City_Reference)
            ->setDestination_Travel_City_Reference($destination_Travel_City_Reference)
            ->setMerchant_Reference($merchant_Reference);
    }
    /**
     * Get Travel_Booking_Record_Confidence_Percentage value
     * @return float|null
     */
    public function getTravel_Booking_Record_Confidence_Percentage()
    {
        return $this->Travel_Booking_Record_Confidence_Percentage;
    }
    /**
     * Set Travel_Booking_Record_Confidence_Percentage value
     * @param float $travel_Booking_Record_Confidence_Percentage
     * @return \StructType\Travel_Booking_Record_Name_Match_DataType
     */
    public function setTravel_Booking_Record_Confidence_Percentage($travel_Booking_Record_Confidence_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($travel_Booking_Record_Confidence_Percentage) && !(is_float($travel_Booking_Record_Confidence_Percentage) || is_numeric($travel_Booking_Record_Confidence_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($travel_Booking_Record_Confidence_Percentage, true), gettype($travel_Booking_Record_Confidence_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($travel_Booking_Record_Confidence_Percentage) && mb_strlen(mb_substr($travel_Booking_Record_Confidence_Percentage, false !== mb_strpos($travel_Booking_Record_Confidence_Percentage, '.') ? mb_strpos($travel_Booking_Record_Confidence_Percentage, '.') + 1 : mb_strlen($travel_Booking_Record_Confidence_Percentage))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($travel_Booking_Record_Confidence_Percentage, true), mb_strlen(mb_substr($travel_Booking_Record_Confidence_Percentage, mb_strpos($travel_Booking_Record_Confidence_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($travel_Booking_Record_Confidence_Percentage) && $travel_Booking_Record_Confidence_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($travel_Booking_Record_Confidence_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($travel_Booking_Record_Confidence_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $travel_Booking_Record_Confidence_Percentage)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($travel_Booking_Record_Confidence_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $travel_Booking_Record_Confidence_Percentage))), __LINE__);
        }
        $this->Travel_Booking_Record_Confidence_Percentage = $travel_Booking_Record_Confidence_Percentage;
        return $this;
    }
    /**
     * Get Origination_Travel_City_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getOrigination_Travel_City_Reference()
    {
        return $this->Origination_Travel_City_Reference;
    }
    /**
     * Set Origination_Travel_City_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $origination_Travel_City_Reference
     * @return \StructType\Travel_Booking_Record_Name_Match_DataType
     */
    public function setOrigination_Travel_City_Reference(\StructType\Abstract_Spend_Data_NameObjectType $origination_Travel_City_Reference = null)
    {
        $this->Origination_Travel_City_Reference = $origination_Travel_City_Reference;
        return $this;
    }
    /**
     * Get Destination_Travel_City_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getDestination_Travel_City_Reference()
    {
        return $this->Destination_Travel_City_Reference;
    }
    /**
     * Set Destination_Travel_City_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference
     * @return \StructType\Travel_Booking_Record_Name_Match_DataType
     */
    public function setDestination_Travel_City_Reference(\StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference = null)
    {
        $this->Destination_Travel_City_Reference = $destination_Travel_City_Reference;
        return $this;
    }
    /**
     * Get Merchant_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getMerchant_Reference()
    {
        return $this->Merchant_Reference;
    }
    /**
     * Set Merchant_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     * @return \StructType\Travel_Booking_Record_Name_Match_DataType
     */
    public function setMerchant_Reference(\StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null)
    {
        $this->Merchant_Reference = $merchant_Reference;
        return $this;
    }
}
