<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_Header_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Travel Booking Header Request.
 * @subpackage Structs
 */
class Travel_Booking_Header_RequestType extends AbstractStructBase
{
    /**
     * The Travel_Booking_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Travel Booking File for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_FileObjectType
     */
    public $Travel_Booking_File_Reference;
    /**
     * The Travel_Booking_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Data.
     * @var \StructType\Travel_Booking_File_DataType
     */
    public $Travel_Booking_File_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Travel_Booking_Header_RequestType
     * @uses Travel_Booking_Header_RequestType::setTravel_Booking_File_Reference()
     * @uses Travel_Booking_Header_RequestType::setTravel_Booking_File_Data()
     * @uses Travel_Booking_Header_RequestType::setAdd_Only()
     * @uses Travel_Booking_Header_RequestType::setVersion()
     * @param \StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference
     * @param \StructType\Travel_Booking_File_DataType $travel_Booking_File_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference = null, \StructType\Travel_Booking_File_DataType $travel_Booking_File_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setTravel_Booking_File_Reference($travel_Booking_File_Reference)
            ->setTravel_Booking_File_Data($travel_Booking_File_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Travel_Booking_File_Reference value
     * @return \StructType\Travel_Booking_FileObjectType|null
     */
    public function getTravel_Booking_File_Reference()
    {
        return $this->Travel_Booking_File_Reference;
    }
    /**
     * Set Travel_Booking_File_Reference value
     * @param \StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference
     * @return \StructType\Travel_Booking_Header_RequestType
     */
    public function setTravel_Booking_File_Reference(\StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference = null)
    {
        $this->Travel_Booking_File_Reference = $travel_Booking_File_Reference;
        return $this;
    }
    /**
     * Get Travel_Booking_File_Data value
     * @return \StructType\Travel_Booking_File_DataType|null
     */
    public function getTravel_Booking_File_Data()
    {
        return $this->Travel_Booking_File_Data;
    }
    /**
     * Set Travel_Booking_File_Data value
     * @param \StructType\Travel_Booking_File_DataType $travel_Booking_File_Data
     * @return \StructType\Travel_Booking_Header_RequestType
     */
    public function setTravel_Booking_File_Data(\StructType\Travel_Booking_File_DataType $travel_Booking_File_Data = null)
    {
        $this->Travel_Booking_File_Data = $travel_Booking_File_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Travel_Booking_Header_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Travel_Booking_Header_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
