<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remove_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Remove Asset operation.
 * @subpackage Structs
 */
class Remove_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Contains data for business processing
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Remove_Asset_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data used to process the asset removal.
     * @var \StructType\Remove_Asset_DataType
     */
    public $Remove_Asset_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Remove_Asset_RequestType
     * @uses Remove_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Remove_Asset_RequestType::setRemove_Asset_Data()
     * @uses Remove_Asset_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Remove_Asset_DataType $remove_Asset_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Remove_Asset_DataType $remove_Asset_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setRemove_Asset_Data($remove_Asset_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Remove_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Remove_Asset_Data value
     * @return \StructType\Remove_Asset_DataType|null
     */
    public function getRemove_Asset_Data()
    {
        return $this->Remove_Asset_Data;
    }
    /**
     * Set Remove_Asset_Data value
     * @param \StructType\Remove_Asset_DataType $remove_Asset_Data
     * @return \StructType\Remove_Asset_RequestType
     */
    public function setRemove_Asset_Data(\StructType\Remove_Asset_DataType $remove_Asset_Data = null)
    {
        $this->Remove_Asset_Data = $remove_Asset_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Remove_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
