<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Timesheet_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Timesheet Request Criteria
 * @subpackage Structs
 */
class Project_Timesheet_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supervisory Organization to search for Timesheets in.
     * @var \StructType\OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Workers to find timesheets for.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Worker_Reference;
    /**
     * The Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Date to find Timesheets with a Period that starts on or after the date specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_After;
    /**
     * The Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Date to find Timesheets with a Period that starts on or before the date specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_Before;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to status to find timesheets for.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Document_Status_Reference;
    /**
     * The Period_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Periods to find timesheets for.
     * - minOccurs: 0
     * @var \StructType\PeriodObjectType
     */
    public $Period_Reference;
    /**
     * The Exclude_Worksheets
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to indicate to exclude Timesheet Types of Project Worksheets. 1 = Exclude Worksheets, 0 = Include Worksheets
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Worksheets;
    /**
     * Constructor method for Project_Timesheet_Request_CriteriaType
     * @uses Project_Timesheet_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Project_Timesheet_Request_CriteriaType::setWorker_Reference()
     * @uses Project_Timesheet_Request_CriteriaType::setStart_Date_On_or_After()
     * @uses Project_Timesheet_Request_CriteriaType::setStart_Date_On_or_Before()
     * @uses Project_Timesheet_Request_CriteriaType::setDocument_Status_Reference()
     * @uses Project_Timesheet_Request_CriteriaType::setPeriod_Reference()
     * @uses Project_Timesheet_Request_CriteriaType::setExclude_Worksheets()
     * @param \StructType\OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @param string $start_Date_On_or_After
     * @param string $start_Date_On_or_Before
     * @param \StructType\Document_StatusObjectType[] $document_Status_Reference
     * @param \StructType\PeriodObjectType $period_Reference
     * @param bool $exclude_Worksheets
     */
    public function __construct(\StructType\OrganizationObjectType $supervisory_Organization_Reference = null, array $worker_Reference = array(), $start_Date_On_or_After = null, $start_Date_On_or_Before = null, array $document_Status_Reference = array(), \StructType\PeriodObjectType $period_Reference = null, $exclude_Worksheets = null)
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setStart_Date_On_or_After($start_Date_On_or_After)
            ->setStart_Date_On_or_Before($start_Date_On_or_Before)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setPeriod_Reference($period_Reference)
            ->setExclude_Worksheets($exclude_Worksheets);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(\StructType\OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem) ? get_class($project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem) : sprintf('%s(%s)', gettype($project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem), var_export($project_Timesheet_Request_CriteriaTypeWorker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setWorker_Reference(array $worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_ReferenceArrayErrorMessage = self::validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function addToWorker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Start_Date_On_or_After value
     * @return string|null
     */
    public function getStart_Date_On_or_After()
    {
        return $this->Start_Date_On_or_After;
    }
    /**
     * Set Start_Date_On_or_After value
     * @param string $start_Date_On_or_After
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setStart_Date_On_or_After($start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_After) && !is_string($start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_After, true), gettype($start_Date_On_or_After)), __LINE__);
        }
        $this->Start_Date_On_or_After = $start_Date_On_or_After;
        return $this;
    }
    /**
     * Get Start_Date_On_or_Before value
     * @return string|null
     */
    public function getStart_Date_On_or_Before()
    {
        return $this->Start_Date_On_or_Before;
    }
    /**
     * Set Start_Date_On_or_Before value
     * @param string $start_Date_On_or_Before
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setStart_Date_On_or_Before($start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_Before) && !is_string($start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_Before, true), gettype($start_Date_On_or_Before)), __LINE__);
        }
        $this->Start_Date_On_or_Before = $start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_Status_ReferenceForArrayConstraintsFromSetDocument_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem) ? get_class($project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem) : sprintf('%s(%s)', gettype($project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem), var_export($project_Timesheet_Request_CriteriaTypeDocument_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $document_Status_Reference
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setDocument_Status_Reference(array $document_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($document_Status_ReferenceArrayErrorMessage = self::validateDocument_Status_ReferenceForArrayConstraintsFromSetDocument_Status_Reference($document_Status_Reference))) {
            throw new \InvalidArgumentException($document_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Add item to Document_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function addToDocument_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Document_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Period_Reference value
     * @return \StructType\PeriodObjectType|null
     */
    public function getPeriod_Reference()
    {
        return $this->Period_Reference;
    }
    /**
     * Set Period_Reference value
     * @param \StructType\PeriodObjectType $period_Reference
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setPeriod_Reference(\StructType\PeriodObjectType $period_Reference = null)
    {
        $this->Period_Reference = $period_Reference;
        return $this;
    }
    /**
     * Get Exclude_Worksheets value
     * @return bool|null
     */
    public function getExclude_Worksheets()
    {
        return $this->Exclude_Worksheets;
    }
    /**
     * Set Exclude_Worksheets value
     * @param bool $exclude_Worksheets
     * @return \StructType\Project_Timesheet_Request_CriteriaType
     */
    public function setExclude_Worksheets($exclude_Worksheets = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Worksheets) && !is_bool($exclude_Worksheets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Worksheets, true), gettype($exclude_Worksheets)), __LINE__);
        }
        $this->Exclude_Worksheets = $exclude_Worksheets;
        return $this;
    }
}
