<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Timesheet_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element encapsulates all the data associated with a single Project Timesheet.
 * @subpackage Structs
 */
class Project_Timesheet_DataType extends AbstractStructBase
{
    /**
     * The Project_Timesheet_ID
     * Meta information extracted from the WSDL
     * - documentation: The unique ID for the Project Timesheet
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Timesheet_ID;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the timesheet inside the Workday application. Timesheet can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Worker this timesheet is for.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Period__Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Period this timesheet covers.
     * - minOccurs: 0
     * @var \StructType\PeriodObjectType
     */
    public $Period__Reference;
    /**
     * The Timesheet_Type_is_Project_Worksheet
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to indicate if the Timesheet Type is a Project Worksheet. 1 = Project Worksheet, 0 = Project Timesheet
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Timesheet_Type_is_Project_Worksheet;
    /**
     * The Project_Timesheet_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Timesheet_Line_DataType[]
     */
    public $Project_Timesheet_Line_Replacement_Data;
    /**
     * Constructor method for Project_Timesheet_DataType
     * @uses Project_Timesheet_DataType::setProject_Timesheet_ID()
     * @uses Project_Timesheet_DataType::setLocked_in_Workday()
     * @uses Project_Timesheet_DataType::setWorker_Reference()
     * @uses Project_Timesheet_DataType::setPeriod__Reference()
     * @uses Project_Timesheet_DataType::setTimesheet_Type_is_Project_Worksheet()
     * @uses Project_Timesheet_DataType::setProject_Timesheet_Line_Replacement_Data()
     * @param string $project_Timesheet_ID
     * @param bool $locked_in_Workday
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\PeriodObjectType $period__Reference
     * @param bool $timesheet_Type_is_Project_Worksheet
     * @param \StructType\Project_Timesheet_Line_DataType[] $project_Timesheet_Line_Replacement_Data
     */
    public function __construct($project_Timesheet_ID = null, $locked_in_Workday = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\PeriodObjectType $period__Reference = null, $timesheet_Type_is_Project_Worksheet = null, array $project_Timesheet_Line_Replacement_Data = array())
    {
        $this
            ->setProject_Timesheet_ID($project_Timesheet_ID)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setWorker_Reference($worker_Reference)
            ->setPeriod__Reference($period__Reference)
            ->setTimesheet_Type_is_Project_Worksheet($timesheet_Type_is_Project_Worksheet)
            ->setProject_Timesheet_Line_Replacement_Data($project_Timesheet_Line_Replacement_Data);
    }
    /**
     * Get Project_Timesheet_ID value
     * @return string|null
     */
    public function getProject_Timesheet_ID()
    {
        return $this->Project_Timesheet_ID;
    }
    /**
     * Set Project_Timesheet_ID value
     * @param string $project_Timesheet_ID
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setProject_Timesheet_ID($project_Timesheet_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Timesheet_ID) && !is_string($project_Timesheet_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Timesheet_ID, true), gettype($project_Timesheet_ID)), __LINE__);
        }
        $this->Project_Timesheet_ID = $project_Timesheet_ID;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Period__Reference value
     * @return \StructType\PeriodObjectType|null
     */
    public function getPeriod__Reference()
    {
        return $this->Period__Reference;
    }
    /**
     * Set Period__Reference value
     * @param \StructType\PeriodObjectType $period__Reference
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setPeriod__Reference(\StructType\PeriodObjectType $period__Reference = null)
    {
        $this->Period__Reference = $period__Reference;
        return $this;
    }
    /**
     * Get Timesheet_Type_is_Project_Worksheet value
     * @return bool|null
     */
    public function getTimesheet_Type_is_Project_Worksheet()
    {
        return $this->Timesheet_Type_is_Project_Worksheet;
    }
    /**
     * Set Timesheet_Type_is_Project_Worksheet value
     * @param bool $timesheet_Type_is_Project_Worksheet
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setTimesheet_Type_is_Project_Worksheet($timesheet_Type_is_Project_Worksheet = null)
    {
        // validation for constraint: boolean
        if (!is_null($timesheet_Type_is_Project_Worksheet) && !is_bool($timesheet_Type_is_Project_Worksheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timesheet_Type_is_Project_Worksheet, true), gettype($timesheet_Type_is_Project_Worksheet)), __LINE__);
        }
        $this->Timesheet_Type_is_Project_Worksheet = $timesheet_Type_is_Project_Worksheet;
        return $this;
    }
    /**
     * Get Project_Timesheet_Line_Replacement_Data value
     * @return \StructType\Project_Timesheet_Line_DataType[]|null
     */
    public function getProject_Timesheet_Line_Replacement_Data()
    {
        return $this->Project_Timesheet_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Timesheet_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Timesheet_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Timesheet_Line_Replacement_DataForArrayConstraintsFromSetProject_Timesheet_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem instanceof \StructType\Project_Timesheet_Line_DataType) {
                $invalidValues[] = is_object($project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem) ? get_class($project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem), var_export($project_Timesheet_DataTypeProject_Timesheet_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Timesheet_Line_Replacement_Data property can only contain items of type \StructType\Project_Timesheet_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Timesheet_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_Line_DataType[] $project_Timesheet_Line_Replacement_Data
     * @return \StructType\Project_Timesheet_DataType
     */
    public function setProject_Timesheet_Line_Replacement_Data(array $project_Timesheet_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Timesheet_Line_Replacement_DataArrayErrorMessage = self::validateProject_Timesheet_Line_Replacement_DataForArrayConstraintsFromSetProject_Timesheet_Line_Replacement_Data($project_Timesheet_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($project_Timesheet_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Timesheet_Line_Replacement_Data = $project_Timesheet_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Project_Timesheet_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_Line_DataType $item
     * @return \StructType\Project_Timesheet_DataType
     */
    public function addToProject_Timesheet_Line_Replacement_Data(\StructType\Project_Timesheet_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Timesheet_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Timesheet_Line_Replacement_Data property can only contain items of type \StructType\Project_Timesheet_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Timesheet_Line_Replacement_Data[] = $item;
        return $this;
    }
}
