<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cash_Advance_Repayment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cash Advance Repayment Data contains all of the enterable information about a Cash Advance Repayment
 * @subpackage Structs
 */
class Cash_Advance_Repayment_DataType extends AbstractStructBase
{
    /**
     * The Cash_Advance_Repayment_ID
     * Meta information extracted from the WSDL
     * - documentation: Cash Advance Repayment ID. This is the Cash Advance Repayment unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cash_Advance_Repayment_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Required field representing the Spend Authorization being repaid by the Cash Advance Repayment.
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The Repayment_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the Cash Advance Repayment is being recorded
     * - maxOccurs: 1
     * @var string
     */
    public $Repayment_Date;
    /**
     * The Repayment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount being repaid with this Cash Advance Repayment | Repayment Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Repayment_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the Cash Advance Repayment. Restricted to Company or Spend Authorization currency
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Type for the Cash Advance Repayment
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference information for the Cash Advance Repayment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Reference;
    /**
     * The Repayment_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for Cash Advance Repayment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Memo;
    /**
     * Constructor method for Cash_Advance_Repayment_DataType
     * @uses Cash_Advance_Repayment_DataType::setCash_Advance_Repayment_ID()
     * @uses Cash_Advance_Repayment_DataType::setSubmit()
     * @uses Cash_Advance_Repayment_DataType::setSpend_Authorization_Reference()
     * @uses Cash_Advance_Repayment_DataType::setRepayment_Date()
     * @uses Cash_Advance_Repayment_DataType::setRepayment_Amount()
     * @uses Cash_Advance_Repayment_DataType::setCurrency_Reference()
     * @uses Cash_Advance_Repayment_DataType::setPayment_Type_Reference()
     * @uses Cash_Advance_Repayment_DataType::setRepayment_Reference()
     * @uses Cash_Advance_Repayment_DataType::setRepayment_Memo()
     * @param string $cash_Advance_Repayment_ID
     * @param bool $submit
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param string $repayment_Date
     * @param float $repayment_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param string $repayment_Reference
     * @param string $repayment_Memo
     */
    public function __construct($cash_Advance_Repayment_ID = null, $submit = null, \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, $repayment_Date = null, $repayment_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $repayment_Reference = null, $repayment_Memo = null)
    {
        $this
            ->setCash_Advance_Repayment_ID($cash_Advance_Repayment_ID)
            ->setSubmit($submit)
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setRepayment_Date($repayment_Date)
            ->setRepayment_Amount($repayment_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setRepayment_Reference($repayment_Reference)
            ->setRepayment_Memo($repayment_Memo);
    }
    /**
     * Get Cash_Advance_Repayment_ID value
     * @return string|null
     */
    public function getCash_Advance_Repayment_ID()
    {
        return $this->Cash_Advance_Repayment_ID;
    }
    /**
     * Set Cash_Advance_Repayment_ID value
     * @param string $cash_Advance_Repayment_ID
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setCash_Advance_Repayment_ID($cash_Advance_Repayment_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cash_Advance_Repayment_ID) && !is_string($cash_Advance_Repayment_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cash_Advance_Repayment_ID, true), gettype($cash_Advance_Repayment_ID)), __LINE__);
        }
        $this->Cash_Advance_Repayment_ID = $cash_Advance_Repayment_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get Repayment_Date value
     * @return string|null
     */
    public function getRepayment_Date()
    {
        return $this->Repayment_Date;
    }
    /**
     * Set Repayment_Date value
     * @param string $repayment_Date
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setRepayment_Date($repayment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Date) && !is_string($repayment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Date, true), gettype($repayment_Date)), __LINE__);
        }
        $this->Repayment_Date = $repayment_Date;
        return $this;
    }
    /**
     * Get Repayment_Amount value
     * @return float|null
     */
    public function getRepayment_Amount()
    {
        return $this->Repayment_Amount;
    }
    /**
     * Set Repayment_Amount value
     * @param float $repayment_Amount
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setRepayment_Amount($repayment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($repayment_Amount) && !(is_float($repayment_Amount) || is_numeric($repayment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($repayment_Amount, true), gettype($repayment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($repayment_Amount) && mb_strlen(mb_substr($repayment_Amount, false !== mb_strpos($repayment_Amount, '.') ? mb_strpos($repayment_Amount, '.') + 1 : mb_strlen($repayment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($repayment_Amount, true), mb_strlen(mb_substr($repayment_Amount, mb_strpos($repayment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($repayment_Amount) && $repayment_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($repayment_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($repayment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($repayment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount))), __LINE__);
        }
        $this->Repayment_Amount = $repayment_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Repayment_Reference value
     * @return string|null
     */
    public function getRepayment_Reference()
    {
        return $this->Repayment_Reference;
    }
    /**
     * Set Repayment_Reference value
     * @param string $repayment_Reference
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setRepayment_Reference($repayment_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Reference) && !is_string($repayment_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Reference, true), gettype($repayment_Reference)), __LINE__);
        }
        $this->Repayment_Reference = $repayment_Reference;
        return $this;
    }
    /**
     * Get Repayment_Memo value
     * @return string|null
     */
    public function getRepayment_Memo()
    {
        return $this->Repayment_Memo;
    }
    /**
     * Set Repayment_Memo value
     * @param string $repayment_Memo
     * @return \StructType\Cash_Advance_Repayment_DataType
     */
    public function setRepayment_Memo($repayment_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Memo) && !is_string($repayment_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Memo, true), gettype($repayment_Memo)), __LINE__);
        }
        $this->Repayment_Memo = $repayment_Memo;
        return $this;
    }
}
