<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Refund_Application_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Refund Application Data
 * @subpackage Structs
 */
class Supplier_Refund_Application_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_Application_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund Application Reference ID. This is the Supplier Refund Application line unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Refund_Application_ID;
    /**
     * The Supplier_Invoice_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Supplier_Invoice_Document_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date for the Referenced Supplier Invoice Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Invoice_Amount
     * Meta information extracted from the WSDL
     * - documentation: Invoice Amount for the Referenced Supplier Invoice Document
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Invoice_Amount;
    /**
     * The Amount_Applied
     * Meta information extracted from the WSDL
     * - documentation: Amount Applied for the Referenced Supplier Invoice Document
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Amount_Applied;
    /**
     * Constructor method for Supplier_Refund_Application_DataType
     * @uses Supplier_Refund_Application_DataType::setSupplier_Refund_Application_ID()
     * @uses Supplier_Refund_Application_DataType::setSupplier_Invoice_Document_Reference()
     * @uses Supplier_Refund_Application_DataType::setInvoice_Date()
     * @uses Supplier_Refund_Application_DataType::setInvoice_Amount()
     * @uses Supplier_Refund_Application_DataType::setAmount_Applied()
     * @param string $supplier_Refund_Application_ID
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference
     * @param string $invoice_Date
     * @param float $invoice_Amount
     * @param float $amount_Applied
     */
    public function __construct($supplier_Refund_Application_ID = null, \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference = null, $invoice_Date = null, $invoice_Amount = null, $amount_Applied = null)
    {
        $this
            ->setSupplier_Refund_Application_ID($supplier_Refund_Application_ID)
            ->setSupplier_Invoice_Document_Reference($supplier_Invoice_Document_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setInvoice_Amount($invoice_Amount)
            ->setAmount_Applied($amount_Applied);
    }
    /**
     * Get Supplier_Refund_Application_ID value
     * @return string|null
     */
    public function getSupplier_Refund_Application_ID()
    {
        return $this->Supplier_Refund_Application_ID;
    }
    /**
     * Set Supplier_Refund_Application_ID value
     * @param string $supplier_Refund_Application_ID
     * @return \StructType\Supplier_Refund_Application_DataType
     */
    public function setSupplier_Refund_Application_ID($supplier_Refund_Application_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Refund_Application_ID) && !is_string($supplier_Refund_Application_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Refund_Application_ID, true), gettype($supplier_Refund_Application_ID)), __LINE__);
        }
        $this->Supplier_Refund_Application_ID = $supplier_Refund_Application_ID;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Document_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getSupplier_Invoice_Document_Reference()
    {
        return $this->Supplier_Invoice_Document_Reference;
    }
    /**
     * Set Supplier_Invoice_Document_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference
     * @return \StructType\Supplier_Refund_Application_DataType
     */
    public function setSupplier_Invoice_Document_Reference(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference = null)
    {
        $this->Supplier_Invoice_Document_Reference = $supplier_Invoice_Document_Reference;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Refund_Application_DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Invoice_Amount value
     * @return float|null
     */
    public function getInvoice_Amount()
    {
        return $this->Invoice_Amount;
    }
    /**
     * Set Invoice_Amount value
     * @param float $invoice_Amount
     * @return \StructType\Supplier_Refund_Application_DataType
     */
    public function setInvoice_Amount($invoice_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($invoice_Amount) && !(is_float($invoice_Amount) || is_numeric($invoice_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoice_Amount, true), gettype($invoice_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($invoice_Amount) && mb_strlen(mb_substr($invoice_Amount, false !== mb_strpos($invoice_Amount, '.') ? mb_strpos($invoice_Amount, '.') + 1 : mb_strlen($invoice_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($invoice_Amount, true), mb_strlen(mb_substr($invoice_Amount, mb_strpos($invoice_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($invoice_Amount) && mb_strlen(preg_replace('/(\D)/', '', $invoice_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($invoice_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $invoice_Amount))), __LINE__);
        }
        $this->Invoice_Amount = $invoice_Amount;
        return $this;
    }
    /**
     * Get Amount_Applied value
     * @return float|null
     */
    public function getAmount_Applied()
    {
        return $this->Amount_Applied;
    }
    /**
     * Set Amount_Applied value
     * @param float $amount_Applied
     * @return \StructType\Supplier_Refund_Application_DataType
     */
    public function setAmount_Applied($amount_Applied = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Applied) && !(is_float($amount_Applied) || is_numeric($amount_Applied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Applied, true), gettype($amount_Applied)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount_Applied) && mb_strlen(mb_substr($amount_Applied, false !== mb_strpos($amount_Applied, '.') ? mb_strpos($amount_Applied, '.') + 1 : mb_strlen($amount_Applied))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount_Applied, true), mb_strlen(mb_substr($amount_Applied, mb_strpos($amount_Applied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($amount_Applied) && mb_strlen(preg_replace('/(\D)/', '', $amount_Applied)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($amount_Applied, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Applied))), __LINE__);
        }
        $this->Amount_Applied = $amount_Applied;
        return $this;
    }
}
