<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier invoice work queue tag assignment rule data.
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: ID for supplier invoice work queue tag assignment rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Ordering used for Supplier Invoice Work Queue Tag Assignment Rule. If this is empty, the Supplier Invoice Work Queue Tag Assignment Rule will be added to the top.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Work queue tags used for Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]
     */
    public $Supplier_Invoice_Work_Queue_Tag_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Terms used for supplier invoice work queue tag assignment rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType[]
     */
    public $Payment_Terms_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier used for Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant Supplier Categories for Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType[]
     */
    public $Supplier_Category_Reference;
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant Supplier Group(s) for Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType[]
     */
    public $Supplier_Group_Reference;
    /**
     * The External_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specify External Transaction Sources that are valid for supplier invoice usage. | External Supplier Invoice Sources for the Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType[]
     */
    public $External_Source_Reference;
    /**
     * The PO_Invoice
     * Meta information extracted from the WSDL
     * - documentation: True if Supplier Invoice Work Queue Tag Assignment Rule pertains to purchase order invoices only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PO_Invoice;
    /**
     * The Non_PO_Invoice
     * Meta information extracted from the WSDL
     * - documentation: True if Supplier Invoice Work Queue Tag Assignment Rule pertains to non-purchase order invoices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_PO_Invoice;
    /**
     * The Greater_Than_Amount
     * Meta information extracted from the WSDL
     * - documentation: Greater than amount for supplier invoice work queue tag assignment rule. | Greater than amount for Supplier Invoice Assignment Rule.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Greater_Than_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Relevant currencies pertaining to Supplier Invoice Work Queue Tag Assignment Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Currency_Reference;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setOrder()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setSupplier_Invoice_Work_Queue_Tag_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setSupplier_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setSupplier_Category_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setSupplier_Group_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setExternal_Source_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setPO_Invoice()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setNon_PO_Invoice()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setGreater_Than_Amount()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType::setCurrency_Reference()
     * @param string $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID
     * @param string $order
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $supplier_Invoice_Work_Queue_Tag_Reference
     * @param \StructType\Payment_TermsObjectType[] $payment_Terms_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Source_Reference
     * @param bool $pO_Invoice
     * @param bool $non_PO_Invoice
     * @param float $greater_Than_Amount
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     */
    public function __construct($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID = null, $order = null, array $supplier_Invoice_Work_Queue_Tag_Reference = array(), array $payment_Terms_Reference = array(), array $supplier_Reference = array(), array $supplier_Category_Reference = array(), array $supplier_Group_Reference = array(), array $external_Source_Reference = array(), $pO_Invoice = null, $non_PO_Invoice = null, $greater_Than_Amount = null, array $currency_Reference = array())
    {
        $this
            ->setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID)
            ->setOrder($order)
            ->setSupplier_Invoice_Work_Queue_Tag_Reference($supplier_Invoice_Work_Queue_Tag_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setSupplier_Group_Reference($supplier_Group_Reference)
            ->setExternal_Source_Reference($external_Source_Reference)
            ->setPO_Invoice($pO_Invoice)
            ->setNon_PO_Invoice($non_PO_Invoice)
            ->setGreater_Than_Amount($greater_Than_Amount)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID value
     * @param string $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID) && !is_string($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID, true), gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID = $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Reference()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Work_Queue_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Work_Queue_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Work_Queue_Tag_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Invoice_Work_Queue_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Work_Queue_Tag_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $supplier_Invoice_Work_Queue_Tag_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Reference(array $supplier_Invoice_Work_Queue_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Work_Queue_Tag_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Work_Queue_Tag_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Reference($supplier_Invoice_Work_Queue_Tag_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Work_Queue_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Reference = $supplier_Invoice_Work_Queue_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Work_Queue_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToSupplier_Invoice_Work_Queue_Tag_Reference(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Work_Queue_Tag_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType[]|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment_Terms_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment_Terms_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayment_Terms_ReferenceForArrayConstraintsFromSetPayment_Terms_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem instanceof \StructType\Payment_TermsObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypePayment_Terms_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment_Terms_Reference property can only contain items of type \StructType\Payment_TermsObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment_Terms_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TermsObjectType[] $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setPayment_Terms_Reference(array $payment_Terms_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payment_Terms_ReferenceArrayErrorMessage = self::validatePayment_Terms_ReferenceForArrayConstraintsFromSetPayment_Terms_Reference($payment_Terms_Reference))) {
            throw new \InvalidArgumentException($payment_Terms_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Add item to Payment_Terms_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TermsObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToPayment_Terms_Reference(\StructType\Payment_TermsObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TermsObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payment_Terms_Reference property can only contain items of type \StructType\Payment_TermsObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment_Terms_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType[]|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem instanceof \StructType\Supplier_CategoryObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setSupplier_Category_Reference(array $supplier_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Category_ReferenceArrayErrorMessage = self::validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference($supplier_Category_Reference))) {
            throw new \InvalidArgumentException($supplier_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType[]|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem instanceof \StructType\Supplier_GroupObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeSupplier_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setSupplier_Group_Reference(array $supplier_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Group_ReferenceArrayErrorMessage = self::validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference($supplier_Group_Reference))) {
            throw new \InvalidArgumentException($supplier_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType[]|null
     */
    public function getExternal_Source_Reference()
    {
        return $this->External_Source_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Source_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Source_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Source_ReferenceForArrayConstraintsFromSetExternal_Source_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem instanceof \StructType\External_Transaction_Source__All_ObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeExternal_Source_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_Source_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setExternal_Source_Reference(array $external_Source_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Source_ReferenceArrayErrorMessage = self::validateExternal_Source_ReferenceForArrayConstraintsFromSetExternal_Source_Reference($external_Source_Reference))) {
            throw new \InvalidArgumentException($external_Source_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->External_Source_Reference = $external_Source_Reference;
        return $this;
    }
    /**
     * Add item to External_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToExternal_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source__All_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The External_Source_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Source_Reference[] = $item;
        return $this;
    }
    /**
     * Get PO_Invoice value
     * @return bool|null
     */
    public function getPO_Invoice()
    {
        return $this->PO_Invoice;
    }
    /**
     * Set PO_Invoice value
     * @param bool $pO_Invoice
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setPO_Invoice($pO_Invoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($pO_Invoice) && !is_bool($pO_Invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pO_Invoice, true), gettype($pO_Invoice)), __LINE__);
        }
        $this->PO_Invoice = $pO_Invoice;
        return $this;
    }
    /**
     * Get Non_PO_Invoice value
     * @return bool|null
     */
    public function getNon_PO_Invoice()
    {
        return $this->Non_PO_Invoice;
    }
    /**
     * Set Non_PO_Invoice value
     * @param bool $non_PO_Invoice
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setNon_PO_Invoice($non_PO_Invoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_PO_Invoice) && !is_bool($non_PO_Invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_PO_Invoice, true), gettype($non_PO_Invoice)), __LINE__);
        }
        $this->Non_PO_Invoice = $non_PO_Invoice;
        return $this;
    }
    /**
     * Get Greater_Than_Amount value
     * @return float|null
     */
    public function getGreater_Than_Amount()
    {
        return $this->Greater_Than_Amount;
    }
    /**
     * Set Greater_Than_Amount value
     * @param float $greater_Than_Amount
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setGreater_Than_Amount($greater_Than_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($greater_Than_Amount) && !(is_float($greater_Than_Amount) || is_numeric($greater_Than_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($greater_Than_Amount, true), gettype($greater_Than_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($greater_Than_Amount) && mb_strlen(mb_substr($greater_Than_Amount, false !== mb_strpos($greater_Than_Amount, '.') ? mb_strpos($greater_Than_Amount, '.') + 1 : mb_strlen($greater_Than_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($greater_Than_Amount, true), mb_strlen(mb_substr($greater_Than_Amount, mb_strpos($greater_Than_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($greater_Than_Amount) && $greater_Than_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($greater_Than_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($greater_Than_Amount) && mb_strlen(preg_replace('/(\D)/', '', $greater_Than_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($greater_Than_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $greater_Than_Amount))), __LINE__);
        }
        $this->Greater_Than_Amount = $greater_Than_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataTypeCurrency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function setCurrency_Reference(array $currency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_ReferenceArrayErrorMessage = self::validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference($currency_Reference))) {
            throw new \InvalidArgumentException($currency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Add item to Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType
     */
    public function addToCurrency_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Reference[] = $item;
        return $this;
    }
}
