<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Amendment_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Supplier Contract Amendment object
 * @subpackage Structs
 */
class Supplier_Contract_Amendment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Amendment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Reference
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Contract_AmendmentObjectType[]
     */
    public $Supplier_Contract_Amendment_Reference;
    /**
     * Constructor method for Supplier_Contract_Amendment_Request_ReferencesType
     * @uses Supplier_Contract_Amendment_Request_ReferencesType::setSupplier_Contract_Amendment_Reference()
     * @param \StructType\Supplier_Contract_AmendmentObjectType[] $supplier_Contract_Amendment_Reference
     */
    public function __construct(array $supplier_Contract_Amendment_Reference = array())
    {
        $this
            ->setSupplier_Contract_Amendment_Reference($supplier_Contract_Amendment_Reference);
    }
    /**
     * Get Supplier_Contract_Amendment_Reference value
     * @return \StructType\Supplier_Contract_AmendmentObjectType[]|null
     */
    public function getSupplier_Contract_Amendment_Reference()
    {
        return $this->Supplier_Contract_Amendment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Amendment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Amendment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Amendment_ReferenceForArrayConstraintsFromSetSupplier_Contract_Amendment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem instanceof \StructType\Supplier_Contract_AmendmentObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem) ? get_class($supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem), var_export($supplier_Contract_Amendment_Request_ReferencesTypeSupplier_Contract_Amendment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Amendment_Reference property can only contain items of type \StructType\Supplier_Contract_AmendmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Amendment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_AmendmentObjectType[] $supplier_Contract_Amendment_Reference
     * @return \StructType\Supplier_Contract_Amendment_Request_ReferencesType
     */
    public function setSupplier_Contract_Amendment_Reference(array $supplier_Contract_Amendment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Amendment_ReferenceArrayErrorMessage = self::validateSupplier_Contract_Amendment_ReferenceForArrayConstraintsFromSetSupplier_Contract_Amendment_Reference($supplier_Contract_Amendment_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_Amendment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Amendment_Reference = $supplier_Contract_Amendment_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Amendment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_AmendmentObjectType $item
     * @return \StructType\Supplier_Contract_Amendment_Request_ReferencesType
     */
    public function addToSupplier_Contract_Amendment_Reference(\StructType\Supplier_Contract_AmendmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_AmendmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Amendment_Reference property can only contain items of type \StructType\Supplier_Contract_AmendmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Amendment_Reference[] = $item;
        return $this;
    }
}
