<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains instances of RFQ Awards for get operation.
 * @subpackage Structs
 */
class Request_for_Quote_Award_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Award_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Request for Quote Award Document.
     * - maxOccurs: unbounded
     * @var \StructType\Request_for_Quote_AwardObjectType[]
     */
    public $Request_for_Quote_Award_Reference;
    /**
     * Constructor method for Request_for_Quote_Award_Request_ReferencesType
     * @uses Request_for_Quote_Award_Request_ReferencesType::setRequest_for_Quote_Award_Reference()
     * @param \StructType\Request_for_Quote_AwardObjectType[] $request_for_Quote_Award_Reference
     */
    public function __construct(array $request_for_Quote_Award_Reference = array())
    {
        $this
            ->setRequest_for_Quote_Award_Reference($request_for_Quote_Award_Reference);
    }
    /**
     * Get Request_for_Quote_Award_Reference value
     * @return \StructType\Request_for_Quote_AwardObjectType[]|null
     */
    public function getRequest_for_Quote_Award_Reference()
    {
        return $this->Request_for_Quote_Award_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_ReferenceForArrayConstraintsFromSetRequest_for_Quote_Award_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem instanceof \StructType\Request_for_Quote_AwardObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem) ? get_class($request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem), var_export($request_for_Quote_Award_Request_ReferencesTypeRequest_for_Quote_Award_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Reference property can only contain items of type \StructType\Request_for_Quote_AwardObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_AwardObjectType[] $request_for_Quote_Award_Reference
     * @return \StructType\Request_for_Quote_Award_Request_ReferencesType
     */
    public function setRequest_for_Quote_Award_Reference(array $request_for_Quote_Award_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_ReferenceArrayErrorMessage = self::validateRequest_for_Quote_Award_ReferenceForArrayConstraintsFromSetRequest_for_Quote_Award_Reference($request_for_Quote_Award_Reference))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Reference = $request_for_Quote_Award_Reference;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_AwardObjectType $item
     * @return \StructType\Request_for_Quote_Award_Request_ReferencesType
     */
    public function addToRequest_for_Quote_Award_Reference(\StructType\Request_for_Quote_AwardObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_AwardObjectType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Reference property can only contain items of type \StructType\Request_for_Quote_AwardObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Reference[] = $item;
        return $this;
    }
}
