<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Classification_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Supplier Classification Response Data
 * @subpackage Structs
 */
class Put_Supplier_Classification_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Classification
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_ClassificationObjectType
     */
    public $Supplier_Classification_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Classification_ResponseType
     * @uses Put_Supplier_Classification_ResponseType::setSupplier_Classification_Reference()
     * @uses Put_Supplier_Classification_ResponseType::setVersion()
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @param string $version
     */
    public function __construct(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Classification_Reference($supplier_Classification_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Classification_Reference value
     * @return \StructType\Custom_Supplier_ClassificationObjectType|null
     */
    public function getSupplier_Classification_Reference()
    {
        return $this->Supplier_Classification_Reference;
    }
    /**
     * Set Supplier_Classification_Reference value
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @return \StructType\Put_Supplier_Classification_ResponseType
     */
    public function setSupplier_Classification_Reference(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null)
    {
        $this->Supplier_Classification_Reference = $supplier_Classification_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Classification_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
