<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Item Attribute Type is required and must have a value. | One Expense Item Tag for the Expense Item
 * @subpackage Structs
 */
class Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType extends AbstractStructBase
{
    /**
     * The Expense_Item_Attribute_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Type Reference defines the type of attribute to be collected for the Expense Item.
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Attribute_TypeObjectType
     */
    public $Expense_Item_Attribute_Type_Reference;
    /**
     * The Display_to_User_on_Expense_Report
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag, Display to User, that displays the expense Item tag on the expense report line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Display_to_User_on_Expense_Report;
    /**
     * The Required_on_Expense_Report
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag, Expense Item Attribute Required, that requires the user to enter a value for an expense Item tag on the expense report line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required_on_Expense_Report;
    /**
     * The Display_to_User_on_Spend_Authorization
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag, Display to User on Spend Authorization, that displays the expense Item tag on the spend authorization line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Display_to_User_on_Spend_Authorization;
    /**
     * The Required_on_Spend_Authorization
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag, Expense Item Attribute Required on Spend Authorization, that requires the user to enter a value for an expense Item tag on the spend authorization line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required_on_Spend_Authorization;
    /**
     * Constructor method for Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     * @uses Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType::setExpense_Item_Attribute_Type_Reference()
     * @uses Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType::setDisplay_to_User_on_Expense_Report()
     * @uses Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType::setRequired_on_Expense_Report()
     * @uses Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType::setDisplay_to_User_on_Spend_Authorization()
     * @uses Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType::setRequired_on_Spend_Authorization()
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference
     * @param bool $display_to_User_on_Expense_Report
     * @param bool $required_on_Expense_Report
     * @param bool $display_to_User_on_Spend_Authorization
     * @param bool $required_on_Spend_Authorization
     */
    public function __construct(\StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference = null, $display_to_User_on_Expense_Report = null, $required_on_Expense_Report = null, $display_to_User_on_Spend_Authorization = null, $required_on_Spend_Authorization = null)
    {
        $this
            ->setExpense_Item_Attribute_Type_Reference($expense_Item_Attribute_Type_Reference)
            ->setDisplay_to_User_on_Expense_Report($display_to_User_on_Expense_Report)
            ->setRequired_on_Expense_Report($required_on_Expense_Report)
            ->setDisplay_to_User_on_Spend_Authorization($display_to_User_on_Spend_Authorization)
            ->setRequired_on_Spend_Authorization($required_on_Spend_Authorization);
    }
    /**
     * Get Expense_Item_Attribute_Type_Reference value
     * @return \StructType\Expense_Item_Attribute_TypeObjectType|null
     */
    public function getExpense_Item_Attribute_Type_Reference()
    {
        return $this->Expense_Item_Attribute_Type_Reference;
    }
    /**
     * Set Expense_Item_Attribute_Type_Reference value
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     */
    public function setExpense_Item_Attribute_Type_Reference(\StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference = null)
    {
        $this->Expense_Item_Attribute_Type_Reference = $expense_Item_Attribute_Type_Reference;
        return $this;
    }
    /**
     * Get Display_to_User_on_Expense_Report value
     * @return bool|null
     */
    public function getDisplay_to_User_on_Expense_Report()
    {
        return $this->Display_to_User_on_Expense_Report;
    }
    /**
     * Set Display_to_User_on_Expense_Report value
     * @param bool $display_to_User_on_Expense_Report
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     */
    public function setDisplay_to_User_on_Expense_Report($display_to_User_on_Expense_Report = null)
    {
        // validation for constraint: boolean
        if (!is_null($display_to_User_on_Expense_Report) && !is_bool($display_to_User_on_Expense_Report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($display_to_User_on_Expense_Report, true), gettype($display_to_User_on_Expense_Report)), __LINE__);
        }
        $this->Display_to_User_on_Expense_Report = $display_to_User_on_Expense_Report;
        return $this;
    }
    /**
     * Get Required_on_Expense_Report value
     * @return bool|null
     */
    public function getRequired_on_Expense_Report()
    {
        return $this->Required_on_Expense_Report;
    }
    /**
     * Set Required_on_Expense_Report value
     * @param bool $required_on_Expense_Report
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     */
    public function setRequired_on_Expense_Report($required_on_Expense_Report = null)
    {
        // validation for constraint: boolean
        if (!is_null($required_on_Expense_Report) && !is_bool($required_on_Expense_Report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required_on_Expense_Report, true), gettype($required_on_Expense_Report)), __LINE__);
        }
        $this->Required_on_Expense_Report = $required_on_Expense_Report;
        return $this;
    }
    /**
     * Get Display_to_User_on_Spend_Authorization value
     * @return bool|null
     */
    public function getDisplay_to_User_on_Spend_Authorization()
    {
        return $this->Display_to_User_on_Spend_Authorization;
    }
    /**
     * Set Display_to_User_on_Spend_Authorization value
     * @param bool $display_to_User_on_Spend_Authorization
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     */
    public function setDisplay_to_User_on_Spend_Authorization($display_to_User_on_Spend_Authorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($display_to_User_on_Spend_Authorization) && !is_bool($display_to_User_on_Spend_Authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($display_to_User_on_Spend_Authorization, true), gettype($display_to_User_on_Spend_Authorization)), __LINE__);
        }
        $this->Display_to_User_on_Spend_Authorization = $display_to_User_on_Spend_Authorization;
        return $this;
    }
    /**
     * Get Required_on_Spend_Authorization value
     * @return bool|null
     */
    public function getRequired_on_Spend_Authorization()
    {
        return $this->Required_on_Spend_Authorization;
    }
    /**
     * Set Required_on_Spend_Authorization value
     * @param bool $required_on_Spend_Authorization
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType
     */
    public function setRequired_on_Spend_Authorization($required_on_Spend_Authorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($required_on_Spend_Authorization) && !is_bool($required_on_Spend_Authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required_on_Spend_Authorization, true), gettype($required_on_Spend_Authorization)), __LINE__);
        }
        $this->Required_on_Spend_Authorization = $required_on_Spend_Authorization;
        return $this;
    }
}
