<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Asset_Book_Restriction_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request criteria for the company asset book restrictions operation.
 * @subpackage Structs
 */
class Company_Asset_Book_Restriction_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Companies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company reference for company asset book restriction
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Companies_Reference;
    /**
     * Constructor method for Company_Asset_Book_Restriction_Request_CriteriaType
     * @uses Company_Asset_Book_Restriction_Request_CriteriaType::setCompanies_Reference()
     * @param \StructType\CompanyObjectType[] $companies_Reference
     */
    public function __construct(array $companies_Reference = array())
    {
        $this
            ->setCompanies_Reference($companies_Reference);
    }
    /**
     * Get Companies_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompanies_Reference()
    {
        return $this->Companies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanies_ReferenceForArrayConstraintsFromSetCompanies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem), var_export($company_Asset_Book_Restriction_Request_CriteriaTypeCompanies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Companies_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $companies_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Request_CriteriaType
     */
    public function setCompanies_Reference(array $companies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($companies_ReferenceArrayErrorMessage = self::validateCompanies_ReferenceForArrayConstraintsFromSetCompanies_Reference($companies_Reference))) {
            throw new \InvalidArgumentException($companies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Companies_Reference = $companies_Reference;
        return $this;
    }
    /**
     * Add item to Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Request_CriteriaType
     */
    public function addToCompanies_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Companies_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Companies_Reference[] = $item;
        return $this;
    }
}
