<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_Type_Level_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code Type Level
 * @subpackage Structs
 */
class Commodity_Code_Type_Level_DataType extends AbstractStructBase
{
    /**
     * The Level_Order
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Type is composed of multiple levels. This attribute indicates the hierarchy order among those levels.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * @var string
     */
    public $Level_Order;
    /**
     * The Level_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the level
     * - maxOccurs: 1
     * @var string
     */
    public $Level_Name;
    /**
     * The Level_Length
     * Meta information extracted from the WSDL
     * - documentation: Number of characters in the level
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Level_Length;
    /**
     * Constructor method for Commodity_Code_Type_Level_DataType
     * @uses Commodity_Code_Type_Level_DataType::setLevel_Order()
     * @uses Commodity_Code_Type_Level_DataType::setLevel_Name()
     * @uses Commodity_Code_Type_Level_DataType::setLevel_Length()
     * @param string $level_Order
     * @param string $level_Name
     * @param float $level_Length
     */
    public function __construct($level_Order = null, $level_Name = null, $level_Length = null)
    {
        $this
            ->setLevel_Order($level_Order)
            ->setLevel_Name($level_Name)
            ->setLevel_Length($level_Length);
    }
    /**
     * Get Level_Order value
     * @return string|null
     */
    public function getLevel_Order()
    {
        return $this->Level_Order;
    }
    /**
     * Set Level_Order value
     * @param string $level_Order
     * @return \StructType\Commodity_Code_Type_Level_DataType
     */
    public function setLevel_Order($level_Order = null)
    {
        // validation for constraint: string
        if (!is_null($level_Order) && !is_string($level_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level_Order, true), gettype($level_Order)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($level_Order) && mb_strlen($level_Order) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($level_Order)), __LINE__);
        }
        $this->Level_Order = $level_Order;
        return $this;
    }
    /**
     * Get Level_Name value
     * @return string|null
     */
    public function getLevel_Name()
    {
        return $this->Level_Name;
    }
    /**
     * Set Level_Name value
     * @param string $level_Name
     * @return \StructType\Commodity_Code_Type_Level_DataType
     */
    public function setLevel_Name($level_Name = null)
    {
        // validation for constraint: string
        if (!is_null($level_Name) && !is_string($level_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level_Name, true), gettype($level_Name)), __LINE__);
        }
        $this->Level_Name = $level_Name;
        return $this;
    }
    /**
     * Get Level_Length value
     * @return float|null
     */
    public function getLevel_Length()
    {
        return $this->Level_Length;
    }
    /**
     * Set Level_Length value
     * @param float $level_Length
     * @return \StructType\Commodity_Code_Type_Level_DataType
     */
    public function setLevel_Length($level_Length = null)
    {
        // validation for constraint: float
        if (!is_null($level_Length) && !(is_float($level_Length) || is_numeric($level_Length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($level_Length, true), gettype($level_Length)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($level_Length) && mb_strlen(mb_substr($level_Length, false !== mb_strpos($level_Length, '.') ? mb_strpos($level_Length, '.') + 1 : mb_strlen($level_Length))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($level_Length, true), mb_strlen(mb_substr($level_Length, mb_strpos($level_Length, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($level_Length) && $level_Length < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($level_Length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($level_Length) && mb_strlen(preg_replace('/(\D)/', '', $level_Length)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($level_Length, true), mb_strlen(preg_replace('/(\D)/', '', $level_Length))), __LINE__);
        }
        $this->Level_Length = $level_Length;
        return $this;
    }
}
