<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to retrieve the reference information for carrier request.
 * @subpackage Structs
 */
class Carrier_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Carrier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Carrier Reference
     * - maxOccurs: unbounded
     * @var \StructType\Dock_Carrier__Audited_ObjectType[]
     */
    public $Carrier_Reference;
    /**
     * Constructor method for Carrier_Request_ReferencesType
     * @uses Carrier_Request_ReferencesType::setCarrier_Reference()
     * @param \StructType\Dock_Carrier__Audited_ObjectType[] $carrier_Reference
     */
    public function __construct(array $carrier_Reference = array())
    {
        $this
            ->setCarrier_Reference($carrier_Reference);
    }
    /**
     * Get Carrier_Reference value
     * @return \StructType\Dock_Carrier__Audited_ObjectType[]|null
     */
    public function getCarrier_Reference()
    {
        return $this->Carrier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrier_ReferenceForArrayConstraintsFromSetCarrier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrier_Request_ReferencesTypeCarrier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$carrier_Request_ReferencesTypeCarrier_ReferenceItem instanceof \StructType\Dock_Carrier__Audited_ObjectType) {
                $invalidValues[] = is_object($carrier_Request_ReferencesTypeCarrier_ReferenceItem) ? get_class($carrier_Request_ReferencesTypeCarrier_ReferenceItem) : sprintf('%s(%s)', gettype($carrier_Request_ReferencesTypeCarrier_ReferenceItem), var_export($carrier_Request_ReferencesTypeCarrier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Carrier_Reference property can only contain items of type \StructType\Dock_Carrier__Audited_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Carrier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Dock_Carrier__Audited_ObjectType[] $carrier_Reference
     * @return \StructType\Carrier_Request_ReferencesType
     */
    public function setCarrier_Reference(array $carrier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($carrier_ReferenceArrayErrorMessage = self::validateCarrier_ReferenceForArrayConstraintsFromSetCarrier_Reference($carrier_Reference))) {
            throw new \InvalidArgumentException($carrier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Carrier_Reference = $carrier_Reference;
        return $this;
    }
    /**
     * Add item to Carrier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Dock_Carrier__Audited_ObjectType $item
     * @return \StructType\Carrier_Request_ReferencesType
     */
    public function addToCarrier_Reference(\StructType\Dock_Carrier__Audited_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dock_Carrier__Audited_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Carrier_Reference property can only contain items of type \StructType\Dock_Carrier__Audited_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Carrier_Reference[] = $item;
        return $this;
    }
}
