<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Purchase_Order_Acknowledgement_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Order Acknowledgements cannot be canceled because the tenant is not configured to use this feature. | Cancel an existing Purchase Order Acknowledgement if it is eligible for Cancel
 * @subpackage Structs
 */
class Cancel_Purchase_Order_Acknowledgement_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_Reference
     * Meta information extracted from the WSDL
     * - documentation: This Acknowledgement cannot be canceled because it has a Document Status of Canceled or Invalid. | Reference to an existing Purchase Order Acknowledgement
     * @var \StructType\Purchase_Order_AcknowledgementObjectType
     */
    public $Purchase_Order_Acknowledgement_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Purchase_Order_Acknowledgement_RequestType
     * @uses Cancel_Purchase_Order_Acknowledgement_RequestType::setPurchase_Order_Acknowledgement_Reference()
     * @uses Cancel_Purchase_Order_Acknowledgement_RequestType::setVersion()
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null, $version = null)
    {
        $this
            ->setPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Acknowledgement_Reference value
     * @return \StructType\Purchase_Order_AcknowledgementObjectType|null
     */
    public function getPurchase_Order_Acknowledgement_Reference()
    {
        return $this->Purchase_Order_Acknowledgement_Reference;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Reference value
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @return \StructType\Cancel_Purchase_Order_Acknowledgement_RequestType
     */
    public function setPurchase_Order_Acknowledgement_Reference(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null)
    {
        $this->Purchase_Order_Acknowledgement_Reference = $purchase_Order_Acknowledgement_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Purchase_Order_Acknowledgement_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
