<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria used to retrieve Advanced Ship Notices. This is mutually exclusive with the Request References element.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Purchase Orders
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType[]
     */
    public $Purchase_Order_Reference;
    /**
     * The Shipment_DateTime_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Shipment Date Time On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_DateTime_On_or_After;
    /**
     * The Shipment_DateTime_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Shipment Date Time On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_DateTime_On_or_Before;
    /**
     * Constructor method for Advanced_Ship_Notice_Request_CriteriaType
     * @uses Advanced_Ship_Notice_Request_CriteriaType::setCompany_Reference()
     * @uses Advanced_Ship_Notice_Request_CriteriaType::setSupplier_Reference()
     * @uses Advanced_Ship_Notice_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Advanced_Ship_Notice_Request_CriteriaType::setShipment_DateTime_On_or_After()
     * @uses Advanced_Ship_Notice_Request_CriteriaType::setShipment_DateTime_On_or_Before()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     * @param string $shipment_DateTime_On_or_After
     * @param string $shipment_DateTime_On_or_Before
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), array $purchase_Order_Reference = array(), $shipment_DateTime_On_or_After = null, $shipment_DateTime_On_or_Before = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setShipment_DateTime_On_or_After($shipment_DateTime_On_or_After)
            ->setShipment_DateTime_On_or_Before($shipment_DateTime_On_or_Before);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem), var_export($advanced_Ship_Notice_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem), var_export($advanced_Ship_Notice_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType[]|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem instanceof \StructType\Purchase_OrderObjectType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem) ? get_class($advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem), var_export($advanced_Ship_Notice_Request_CriteriaTypePurchase_Order_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(array $purchase_Order_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_ReferenceArrayErrorMessage = self::validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference($purchase_Order_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType $item
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function addToPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_OrderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Reference[] = $item;
        return $this;
    }
    /**
     * Get Shipment_DateTime_On_or_After value
     * @return string|null
     */
    public function getShipment_DateTime_On_or_After()
    {
        return $this->Shipment_DateTime_On_or_After;
    }
    /**
     * Set Shipment_DateTime_On_or_After value
     * @param string $shipment_DateTime_On_or_After
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function setShipment_DateTime_On_or_After($shipment_DateTime_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_DateTime_On_or_After) && !is_string($shipment_DateTime_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_DateTime_On_or_After, true), gettype($shipment_DateTime_On_or_After)), __LINE__);
        }
        $this->Shipment_DateTime_On_or_After = $shipment_DateTime_On_or_After;
        return $this;
    }
    /**
     * Get Shipment_DateTime_On_or_Before value
     * @return string|null
     */
    public function getShipment_DateTime_On_or_Before()
    {
        return $this->Shipment_DateTime_On_or_Before;
    }
    /**
     * Set Shipment_DateTime_On_or_Before value
     * @param string $shipment_DateTime_On_or_Before
     * @return \StructType\Advanced_Ship_Notice_Request_CriteriaType
     */
    public function setShipment_DateTime_On_or_Before($shipment_DateTime_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_DateTime_On_or_Before) && !is_string($shipment_DateTime_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_DateTime_On_or_Before, true), gettype($shipment_DateTime_On_or_Before)), __LINE__);
        }
        $this->Shipment_DateTime_On_or_Before = $shipment_DateTime_On_or_Before;
        return $this;
    }
}
