<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Company_Asset_Book_Restrictions_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the Company for Company Asset Book Restrictions and all its corresponding Company Asset Book Restrictions
 * @subpackage Structs
 */
class Put_Company_Asset_Book_Restrictions_ResponseType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Company_Asset_Book_Restriction_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Company_Asset_Book_Restriction_Data_ResponseType[]
     */
    public $Company_Asset_Book_Restriction_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Company_Asset_Book_Restrictions_ResponseType
     * @uses Put_Company_Asset_Book_Restrictions_ResponseType::setCompany_Reference()
     * @uses Put_Company_Asset_Book_Restrictions_ResponseType::setCompany_Asset_Book_Restriction_Data()
     * @uses Put_Company_Asset_Book_Restrictions_ResponseType::setVersion()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Company_Asset_Book_Restriction_Data_ResponseType[] $company_Asset_Book_Restriction_Data
     * @param string $version
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, array $company_Asset_Book_Restriction_Data = array(), $version = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setCompany_Asset_Book_Restriction_Data($company_Asset_Book_Restriction_Data)
            ->setVersion($version);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Put_Company_Asset_Book_Restrictions_ResponseType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Company_Asset_Book_Restriction_Data value
     * @return \StructType\Company_Asset_Book_Restriction_Data_ResponseType[]|null
     */
    public function getCompany_Asset_Book_Restriction_Data()
    {
        return $this->Company_Asset_Book_Restriction_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Asset_Book_Restriction_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Asset_Book_Restriction_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Asset_Book_Restriction_DataForArrayConstraintsFromSetCompany_Asset_Book_Restriction_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem) {
            // validation for constraint: itemType
            if (!$put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem instanceof \StructType\Company_Asset_Book_Restriction_Data_ResponseType) {
                $invalidValues[] = is_object($put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem) ? get_class($put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem) : sprintf('%s(%s)', gettype($put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem), var_export($put_Company_Asset_Book_Restrictions_ResponseTypeCompany_Asset_Book_Restriction_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Asset_Book_Restriction_Data property can only contain items of type \StructType\Company_Asset_Book_Restriction_Data_ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Asset_Book_Restriction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_Restriction_Data_ResponseType[] $company_Asset_Book_Restriction_Data
     * @return \StructType\Put_Company_Asset_Book_Restrictions_ResponseType
     */
    public function setCompany_Asset_Book_Restriction_Data(array $company_Asset_Book_Restriction_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Asset_Book_Restriction_DataArrayErrorMessage = self::validateCompany_Asset_Book_Restriction_DataForArrayConstraintsFromSetCompany_Asset_Book_Restriction_Data($company_Asset_Book_Restriction_Data))) {
            throw new \InvalidArgumentException($company_Asset_Book_Restriction_DataArrayErrorMessage, __LINE__);
        }
        $this->Company_Asset_Book_Restriction_Data = $company_Asset_Book_Restriction_Data;
        return $this;
    }
    /**
     * Add item to Company_Asset_Book_Restriction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_Restriction_Data_ResponseType $item
     * @return \StructType\Put_Company_Asset_Book_Restrictions_ResponseType
     */
    public function addToCompany_Asset_Book_Restriction_Data(\StructType\Company_Asset_Book_Restriction_Data_ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company_Asset_Book_Restriction_Data_ResponseType) {
            throw new \InvalidArgumentException(sprintf('The Company_Asset_Book_Restriction_Data property can only contain items of type \StructType\Company_Asset_Book_Restriction_Data_ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Asset_Book_Restriction_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Company_Asset_Book_Restrictions_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
