<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Custodian_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about each time this asset was Issued to a Worker or Transferred.
 * @subpackage Structs
 */
class Asset_Custodian_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The transaction effective date of this asset issue or asset transfer activity.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Issued_To_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worker the asset was issued or transferred to, if available.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Issued_To_Worker_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktags specified on this issue or transfer activity, including the new Location for the asset.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * Constructor method for Asset_Custodian_WWS_DataType
     * @uses Asset_Custodian_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Custodian_WWS_DataType::setIssued_To_Worker_Reference()
     * @uses Asset_Custodian_WWS_DataType::setWorktag_Reference()
     * @param string $transaction_Effective_Date
     * @param \StructType\WorkerObjectType $issued_To_Worker_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     */
    public function __construct($transaction_Effective_Date = null, \StructType\WorkerObjectType $issued_To_Worker_Reference = null, array $worktag_Reference = array())
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setIssued_To_Worker_Reference($issued_To_Worker_Reference)
            ->setWorktag_Reference($worktag_Reference);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Custodian_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Issued_To_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getIssued_To_Worker_Reference()
    {
        return $this->Issued_To_Worker_Reference;
    }
    /**
     * Set Issued_To_Worker_Reference value
     * @param \StructType\WorkerObjectType $issued_To_Worker_Reference
     * @return \StructType\Asset_Custodian_WWS_DataType
     */
    public function setIssued_To_Worker_Reference(\StructType\WorkerObjectType $issued_To_Worker_Reference = null)
    {
        $this->Issued_To_Worker_Reference = $issued_To_Worker_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Custodian_WWS_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Custodian_WWS_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Custodian_WWS_DataTypeWorktag_ReferenceItem) ? get_class($asset_Custodian_WWS_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Custodian_WWS_DataTypeWorktag_ReferenceItem), var_export($asset_Custodian_WWS_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Asset_Custodian_WWS_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Custodian_WWS_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
}
