<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line_Alternate_Item_Attribute_Value_Data_InboundType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures Alternate Item Identifiers for a Line
 * @subpackage Structs
 */
class Line_Alternate_Item_Attribute_Value_Data_InboundType extends AbstractStructBase
{
    /**
     * The External_Name
     * Meta information extracted from the WSDL
     * - documentation: External Name of Alternate Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Alternate Identifier Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Manufacturer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Manufacturer associated with the Item Identifier Type
     * - minOccurs: 0
     * @var \StructType\ManufacturerObjectType
     */
    public $Manufacturer_Reference;
    /**
     * Constructor method for Line_Alternate_Item_Attribute_Value_Data_InboundType
     * @uses Line_Alternate_Item_Attribute_Value_Data_InboundType::setExternal_Name()
     * @uses Line_Alternate_Item_Attribute_Value_Data_InboundType::setValue()
     * @uses Line_Alternate_Item_Attribute_Value_Data_InboundType::setManufacturer_Reference()
     * @param string $external_Name
     * @param string $value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     */
    public function __construct($external_Name = null, $value = null, \StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this
            ->setExternal_Name($external_Name)
            ->setValue($value)
            ->setManufacturer_Reference($manufacturer_Reference);
    }
    /**
     * Get External_Name value
     * @return string|null
     */
    public function getExternal_Name()
    {
        return $this->External_Name;
    }
    /**
     * Set External_Name value
     * @param string $external_Name
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType
     */
    public function setExternal_Name($external_Name = null)
    {
        // validation for constraint: string
        if (!is_null($external_Name) && !is_string($external_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Name, true), gettype($external_Name)), __LINE__);
        }
        $this->External_Name = $external_Name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Manufacturer_Reference value
     * @return \StructType\ManufacturerObjectType|null
     */
    public function getManufacturer_Reference()
    {
        return $this->Manufacturer_Reference;
    }
    /**
     * Set Manufacturer_Reference value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType
     */
    public function setManufacturer_Reference(\StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this->Manufacturer_Reference = $manufacturer_Reference;
        return $this;
    }
}
