<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Advanced_Pricing_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier specific Advanced Pricing rule. Can be an update of existing rule or a new one.
 * @subpackage Structs
 */
class Supplier_Item_Advanced_Pricing_DataType extends AbstractStructBase
{
    /**
     * The Advanced_Pricing_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier specific Advanced Pricing rule being updated.
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Advanced_PricingObjectType
     */
    public $Advanced_Pricing_Reference;
    /**
     * The Advanced_Pricing_ID
     * Meta information extracted from the WSDL
     * - documentation: Advanced Pricing rule ID. This is a unique identifier. For imports, if both Advanced Pricing Reference and Advanced Pricing ID are present, the Advanced Pricing Reference is the one being updated, and ID will be used to replaced the
     * ID value on that rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Advanced_Pricing_ID;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date for Advanced Pricing. The document date must be on or after this date for the Advanced Pricing rule to apply.
     * - maxOccurs: 1
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date for Advanced Pricing. If present, the document date must be on or before this date for the Advanced Pricing rule to apply.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract for Supplier Item Advanced Pricing
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more companies for Advanced Pricing. If any is a match for the document company, it is used to determine when to apply an advanced pricing rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Ship_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more locations for Advanced Pricing. If there is a match for the location associated with the Ship-To Address on a transaction line, it is used to determine when to apply an advanced pricing rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Location_or_Location_HierarchyObjectType[]
     */
    public $Ship_To_Location_Reference;
    /**
     * The Just_In_Time
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Advanced Pricing rule is used for Just In Time document lines, or if not set, for bulk ordering lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Just_In_Time;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure for Advanced Pricing rule.
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Price of Catalog Item starting on the Effective Date. | Item Unit Price | Unit Cost of Purchase Item for the corresponding UOM. | Unit Price. | Unit Price for Advanced Pricing Rule. The currency is the same as the supplier
     * information detail. | Unit Price for the JIT UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items. | Unit Price of the Ordering UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Price;
    /**
     * The Contract_Price
     * Meta information extracted from the WSDL
     * - documentation: Contract Price of the Catalog or Supplier Item. This is for informational purposes when using Get Purchase Item web service.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Contract_Price;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for Supplier Item Advanced Pricing - Cannot be Updated
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: True is the Advanced Pricing rule is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Supplier_Item_Advanced_Pricing_DataType
     * @uses Supplier_Item_Advanced_Pricing_DataType::setAdvanced_Pricing_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setAdvanced_Pricing_ID()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setStart_Date()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setEnd_Date()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setCompany_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setShip_To_Location_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setJust_In_Time()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setUnit_of_Measure_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setUnit_Price()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setContract_Price()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setCurrency_Reference()
     * @uses Supplier_Item_Advanced_Pricing_DataType::setInactive()
     * @param \StructType\Supplier_Item_Advanced_PricingObjectType $advanced_Pricing_Reference
     * @param string $advanced_Pricing_ID
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $ship_To_Location_Reference
     * @param bool $just_In_Time
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Price
     * @param float $contract_Price
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param bool $inactive
     */
    public function __construct(\StructType\Supplier_Item_Advanced_PricingObjectType $advanced_Pricing_Reference = null, $advanced_Pricing_ID = null, $start_Date = null, $end_Date = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $company_Reference = array(), array $ship_To_Location_Reference = array(), $just_In_Time = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Price = null, $contract_Price = null, \StructType\CurrencyObjectType $currency_Reference = null, $inactive = null)
    {
        $this
            ->setAdvanced_Pricing_Reference($advanced_Pricing_Reference)
            ->setAdvanced_Pricing_ID($advanced_Pricing_ID)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setCompany_Reference($company_Reference)
            ->setShip_To_Location_Reference($ship_To_Location_Reference)
            ->setJust_In_Time($just_In_Time)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Price($unit_Price)
            ->setContract_Price($contract_Price)
            ->setCurrency_Reference($currency_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get Advanced_Pricing_Reference value
     * @return \StructType\Supplier_Item_Advanced_PricingObjectType|null
     */
    public function getAdvanced_Pricing_Reference()
    {
        return $this->Advanced_Pricing_Reference;
    }
    /**
     * Set Advanced_Pricing_Reference value
     * @param \StructType\Supplier_Item_Advanced_PricingObjectType $advanced_Pricing_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setAdvanced_Pricing_Reference(\StructType\Supplier_Item_Advanced_PricingObjectType $advanced_Pricing_Reference = null)
    {
        $this->Advanced_Pricing_Reference = $advanced_Pricing_Reference;
        return $this;
    }
    /**
     * Get Advanced_Pricing_ID value
     * @return string|null
     */
    public function getAdvanced_Pricing_ID()
    {
        return $this->Advanced_Pricing_ID;
    }
    /**
     * Set Advanced_Pricing_ID value
     * @param string $advanced_Pricing_ID
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setAdvanced_Pricing_ID($advanced_Pricing_ID = null)
    {
        // validation for constraint: string
        if (!is_null($advanced_Pricing_ID) && !is_string($advanced_Pricing_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advanced_Pricing_ID, true), gettype($advanced_Pricing_ID)), __LINE__);
        }
        $this->Advanced_Pricing_ID = $advanced_Pricing_ID;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem) ? get_class($supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem), var_export($supplier_Item_Advanced_Pricing_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Location_Reference value
     * @return \StructType\Asset_Location_or_Location_HierarchyObjectType[]|null
     */
    public function getShip_To_Location_Reference()
    {
        return $this->Ship_To_Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Location_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Location_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_Location_ReferenceForArrayConstraintsFromSetShip_To_Location_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
                $invalidValues[] = is_object($supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem) ? get_class($supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem), var_export($supplier_Item_Advanced_Pricing_DataTypeShip_To_Location_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $ship_To_Location_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setShip_To_Location_Reference(array $ship_To_Location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_Location_ReferenceArrayErrorMessage = self::validateShip_To_Location_ReferenceForArrayConstraintsFromSetShip_To_Location_Reference($ship_To_Location_Reference))) {
            throw new \InvalidArgumentException($ship_To_Location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Location_Reference = $ship_To_Location_Reference;
        return $this;
    }
    /**
     * Add item to Ship_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType $item
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function addToShip_To_Location_Reference(\StructType\Asset_Location_or_Location_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Just_In_Time value
     * @return bool|null
     */
    public function getJust_In_Time()
    {
        return $this->Just_In_Time;
    }
    /**
     * Set Just_In_Time value
     * @param bool $just_In_Time
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setJust_In_Time($just_In_Time = null)
    {
        // validation for constraint: boolean
        if (!is_null($just_In_Time) && !is_bool($just_In_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($just_In_Time, true), gettype($just_In_Time)), __LINE__);
        }
        $this->Just_In_Time = $just_In_Time;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Price value
     * @return float|null
     */
    public function getUnit_Price()
    {
        return $this->Unit_Price;
    }
    /**
     * Set Unit_Price value
     * @param float $unit_Price
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setUnit_Price($unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Price) && !(is_float($unit_Price) || is_numeric($unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Price, true), gettype($unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Price) && mb_strlen(mb_substr($unit_Price, false !== mb_strpos($unit_Price, '.') ? mb_strpos($unit_Price, '.') + 1 : mb_strlen($unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Price, true), mb_strlen(mb_substr($unit_Price, mb_strpos($unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Price))), __LINE__);
        }
        $this->Unit_Price = $unit_Price;
        return $this;
    }
    /**
     * Get Contract_Price value
     * @return float|null
     */
    public function getContract_Price()
    {
        return $this->Contract_Price;
    }
    /**
     * Set Contract_Price value
     * @param float $contract_Price
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setContract_Price($contract_Price = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Price) && !(is_float($contract_Price) || is_numeric($contract_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Price, true), gettype($contract_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($contract_Price) && mb_strlen(mb_substr($contract_Price, false !== mb_strpos($contract_Price, '.') ? mb_strpos($contract_Price, '.') + 1 : mb_strlen($contract_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($contract_Price, true), mb_strlen(mb_substr($contract_Price, mb_strpos($contract_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($contract_Price) && mb_strlen(preg_replace('/(\D)/', '', $contract_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($contract_Price, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Price))), __LINE__);
        }
        $this->Contract_Price = $contract_Price;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Supplier_Item_Advanced_Pricing_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
