<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_LineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Invoice Line
 * @subpackage Structs
 */
class Supplier_Invoice_LineType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Line
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_LineObjectType
     */
    public $Supplier_Invoice_Line_Reference;
    /**
     * The Supplier_Invoice_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Document
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Supplier_Invoice_Document_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Document Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The PO_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Type Reference
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType
     */
    public $PO_Type_Reference;
    /**
     * The Supplier_Invoice_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Line Replacement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Replacement_DataType[]
     */
    public $Supplier_Invoice_Line_Replacement_Data;
    /**
     * The Gross_Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: The sum of the cost values for material, tax, freight, and other charges for those invoice lines.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Gross_Unit_Cost;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Supplier_Invoice_LineType
     * @uses Supplier_Invoice_LineType::setSupplier_Invoice_Line_Reference()
     * @uses Supplier_Invoice_LineType::setSupplier_Invoice_Document_Reference()
     * @uses Supplier_Invoice_LineType::setInvoice_Status_Reference()
     * @uses Supplier_Invoice_LineType::setPurchase_Order_Reference()
     * @uses Supplier_Invoice_LineType::setPO_Type_Reference()
     * @uses Supplier_Invoice_LineType::setSupplier_Invoice_Line_Replacement_Data()
     * @uses Supplier_Invoice_LineType::setGross_Unit_Cost()
     * @uses Supplier_Invoice_LineType::setCurrency_Reference()
     * @param \StructType\Supplier_Invoice_LineObjectType $supplier_Invoice_Line_Reference
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Order_TypeObjectType $pO_Type_Reference
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $supplier_Invoice_Line_Replacement_Data
     * @param float $gross_Unit_Cost
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct(\StructType\Supplier_Invoice_LineObjectType $supplier_Invoice_Line_Reference = null, \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Order_TypeObjectType $pO_Type_Reference = null, array $supplier_Invoice_Line_Replacement_Data = array(), $gross_Unit_Cost = null, \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference)
            ->setSupplier_Invoice_Document_Reference($supplier_Invoice_Document_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setPO_Type_Reference($pO_Type_Reference)
            ->setSupplier_Invoice_Line_Replacement_Data($supplier_Invoice_Line_Replacement_Data)
            ->setGross_Unit_Cost($gross_Unit_Cost)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Supplier_Invoice_Line_Reference value
     * @return \StructType\Supplier_Invoice_LineObjectType|null
     */
    public function getSupplier_Invoice_Line_Reference()
    {
        return $this->Supplier_Invoice_Line_Reference;
    }
    /**
     * Set Supplier_Invoice_Line_Reference value
     * @param \StructType\Supplier_Invoice_LineObjectType $supplier_Invoice_Line_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setSupplier_Invoice_Line_Reference(\StructType\Supplier_Invoice_LineObjectType $supplier_Invoice_Line_Reference = null)
    {
        $this->Supplier_Invoice_Line_Reference = $supplier_Invoice_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Document_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getSupplier_Invoice_Document_Reference()
    {
        return $this->Supplier_Invoice_Document_Reference;
    }
    /**
     * Set Supplier_Invoice_Document_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setSupplier_Invoice_Document_Reference(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Document_Reference = null)
    {
        $this->Supplier_Invoice_Document_Reference = $supplier_Invoice_Document_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get PO_Type_Reference value
     * @return \StructType\Order_TypeObjectType|null
     */
    public function getPO_Type_Reference()
    {
        return $this->PO_Type_Reference;
    }
    /**
     * Set PO_Type_Reference value
     * @param \StructType\Order_TypeObjectType $pO_Type_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setPO_Type_Reference(\StructType\Order_TypeObjectType $pO_Type_Reference = null)
    {
        $this->PO_Type_Reference = $pO_Type_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Replacement_Data value
     * @return \StructType\Supplier_Invoice_Line_Replacement_DataType[]|null
     */
    public function getSupplier_Invoice_Line_Replacement_Data()
    {
        return $this->Supplier_Invoice_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Line_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem) ? get_class($supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem), var_export($supplier_Invoice_LineTypeSupplier_Invoice_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $supplier_Invoice_Line_Replacement_Data
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setSupplier_Invoice_Line_Replacement_Data(array $supplier_Invoice_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Line_Replacement_DataArrayErrorMessage = self::validateSupplier_Invoice_Line_Replacement_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Replacement_Data($supplier_Invoice_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line_Replacement_Data = $supplier_Invoice_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType $item
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function addToSupplier_Invoice_Line_Replacement_Data(\StructType\Supplier_Invoice_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Gross_Unit_Cost value
     * @return float|null
     */
    public function getGross_Unit_Cost()
    {
        return $this->Gross_Unit_Cost;
    }
    /**
     * Set Gross_Unit_Cost value
     * @param float $gross_Unit_Cost
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setGross_Unit_Cost($gross_Unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($gross_Unit_Cost) && !(is_float($gross_Unit_Cost) || is_numeric($gross_Unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gross_Unit_Cost, true), gettype($gross_Unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($gross_Unit_Cost) && mb_strlen(mb_substr($gross_Unit_Cost, false !== mb_strpos($gross_Unit_Cost, '.') ? mb_strpos($gross_Unit_Cost, '.') + 1 : mb_strlen($gross_Unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($gross_Unit_Cost, true), mb_strlen(mb_substr($gross_Unit_Cost, mb_strpos($gross_Unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($gross_Unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $gross_Unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($gross_Unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $gross_Unit_Cost))), __LINE__);
        }
        $this->Gross_Unit_Cost = $gross_Unit_Cost;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_LineType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
