<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Internal_Service_Delivery_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Topmost element encapsulating everything needed to create an Internal Service Delivery. It includes a flag to indicate if this operation is add only, Business
 * Process parameters, Reference to an existing Internal Service Delivery and the Internal Service Delivery Data sub-element which represents the contents of the document (including lines, splits and attachments).
 * @subpackage Structs
 */
class Submit_Internal_Service_Delivery_RequestType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Service Delivery, used in update operation.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_DeliveryObjectType
     */
    public $Internal_Service_Delivery_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Internal_Service_Delivery_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures information used to create an Internal Service Delivery. It includes Internal Service Delivery Lines (with or without Splits) and attachments information.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public $Internal_Service_Delivery_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Internal_Service_Delivery_RequestType
     * @uses Submit_Internal_Service_Delivery_RequestType::setInternal_Service_Delivery_Reference()
     * @uses Submit_Internal_Service_Delivery_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Internal_Service_Delivery_RequestType::setInternal_Service_Delivery_Data()
     * @uses Submit_Internal_Service_Delivery_RequestType::setAdd_Only()
     * @uses Submit_Internal_Service_Delivery_RequestType::setVersion()
     * @param \StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Internal_Service_Delivery_Data_InboundType $internal_Service_Delivery_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Internal_Service_Delivery_Data_InboundType $internal_Service_Delivery_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setInternal_Service_Delivery_Reference($internal_Service_Delivery_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setInternal_Service_Delivery_Data($internal_Service_Delivery_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Internal_Service_Delivery_Reference value
     * @return \StructType\Internal_Service_DeliveryObjectType|null
     */
    public function getInternal_Service_Delivery_Reference()
    {
        return $this->Internal_Service_Delivery_Reference;
    }
    /**
     * Set Internal_Service_Delivery_Reference value
     * @param \StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference
     * @return \StructType\Submit_Internal_Service_Delivery_RequestType
     */
    public function setInternal_Service_Delivery_Reference(\StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference = null)
    {
        $this->Internal_Service_Delivery_Reference = $internal_Service_Delivery_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Internal_Service_Delivery_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Data value
     * @return \StructType\Internal_Service_Delivery_Data_InboundType|null
     */
    public function getInternal_Service_Delivery_Data()
    {
        return $this->Internal_Service_Delivery_Data;
    }
    /**
     * Set Internal_Service_Delivery_Data value
     * @param \StructType\Internal_Service_Delivery_Data_InboundType $internal_Service_Delivery_Data
     * @return \StructType\Submit_Internal_Service_Delivery_RequestType
     */
    public function setInternal_Service_Delivery_Data(\StructType\Internal_Service_Delivery_Data_InboundType $internal_Service_Delivery_Data = null)
    {
        $this->Internal_Service_Delivery_Data = $internal_Service_Delivery_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Internal_Service_Delivery_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Internal_Service_Delivery_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
