<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Projects_HierarchyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Hierarchy Element.
 * @subpackage Structs
 */
class Projects_HierarchyType extends AbstractStructBase
{
    /**
     * The Project_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy Request Reference Element.
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Project_Hierarchy_Reference;
    /**
     * The Project_Hierarchy_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Hierarchy_WWS_DataType[]
     */
    public $Project_Hierarchy_Data;
    /**
     * Constructor method for Projects_HierarchyType
     * @uses Projects_HierarchyType::setProject_Hierarchy_Reference()
     * @uses Projects_HierarchyType::setProject_Hierarchy_Data()
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @param \StructType\Project_Hierarchy_WWS_DataType[] $project_Hierarchy_Data
     */
    public function __construct(\StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null, array $project_Hierarchy_Data = array())
    {
        $this
            ->setProject_Hierarchy_Reference($project_Hierarchy_Reference)
            ->setProject_Hierarchy_Data($project_Hierarchy_Data);
    }
    /**
     * Get Project_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getProject_Hierarchy_Reference()
    {
        return $this->Project_Hierarchy_Reference;
    }
    /**
     * Set Project_Hierarchy_Reference value
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @return \StructType\Projects_HierarchyType
     */
    public function setProject_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null)
    {
        $this->Project_Hierarchy_Reference = $project_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Project_Hierarchy_Data value
     * @return \StructType\Project_Hierarchy_WWS_DataType[]|null
     */
    public function getProject_Hierarchy_Data()
    {
        return $this->Project_Hierarchy_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Hierarchy_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Hierarchy_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Hierarchy_DataForArrayConstraintsFromSetProject_Hierarchy_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projects_HierarchyTypeProject_Hierarchy_DataItem) {
            // validation for constraint: itemType
            if (!$projects_HierarchyTypeProject_Hierarchy_DataItem instanceof \StructType\Project_Hierarchy_WWS_DataType) {
                $invalidValues[] = is_object($projects_HierarchyTypeProject_Hierarchy_DataItem) ? get_class($projects_HierarchyTypeProject_Hierarchy_DataItem) : sprintf('%s(%s)', gettype($projects_HierarchyTypeProject_Hierarchy_DataItem), var_export($projects_HierarchyTypeProject_Hierarchy_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Hierarchy_Data property can only contain items of type \StructType\Project_Hierarchy_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Hierarchy_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Hierarchy_WWS_DataType[] $project_Hierarchy_Data
     * @return \StructType\Projects_HierarchyType
     */
    public function setProject_Hierarchy_Data(array $project_Hierarchy_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Hierarchy_DataArrayErrorMessage = self::validateProject_Hierarchy_DataForArrayConstraintsFromSetProject_Hierarchy_Data($project_Hierarchy_Data))) {
            throw new \InvalidArgumentException($project_Hierarchy_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Hierarchy_Data = $project_Hierarchy_Data;
        return $this;
    }
    /**
     * Add item to Project_Hierarchy_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Hierarchy_WWS_DataType $item
     * @return \StructType\Projects_HierarchyType
     */
    public function addToProject_Hierarchy_Data(\StructType\Project_Hierarchy_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Hierarchy_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Hierarchy_Data property can only contain items of type \StructType\Project_Hierarchy_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Hierarchy_Data[] = $item;
        return $this;
    }
}
