<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_Installment_Line_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Data representing one installment line for an installment.
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_Installment_Line_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplier invoice line or accounting adjustment line this installment line references. The supplier invoice line can also be a split line.
     * @var \StructType\Installment_ItemObjectType
     */
    public $Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount for the project subtask. | Unit cost for the expense report line. Leave blank if you are entering a credit card transaction. | The amount of the installment line. | Transaction Extended Amount | The payment amount for this
     * lease payment line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Accounting Worktags of the installment line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Prepaid_Spend_Amortization_Installment_Line_DataType
     * @uses Prepaid_Spend_Amortization_Installment_Line_DataType::setSupplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference()
     * @uses Prepaid_Spend_Amortization_Installment_Line_DataType::setAmount()
     * @uses Prepaid_Spend_Amortization_Installment_Line_DataType::setWorktags_Reference()
     * @param \StructType\Installment_ItemObjectType $supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference
     * @param float $amount
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct(\StructType\Installment_ItemObjectType $supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference = null, $amount = null, array $worktags_Reference = array())
    {
        $this
            ->setSupplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference($supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference)
            ->setAmount($amount)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference value
     * @return \StructType\Installment_ItemObjectType|null
     */
    public function getSupplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference()
    {
        return $this->Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference;
    }
    /**
     * Set Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference value
     * @param \StructType\Installment_ItemObjectType $supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference
     * @return \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType
     */
    public function setSupplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference(\StructType\Installment_ItemObjectType $supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference = null)
    {
        $this->Supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference = $supplier_Invoice_Line_or_Accounting_Adjustment_Line_Reference;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem) ? get_class($prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem), var_export($prepaid_Spend_Amortization_Installment_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
