<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_AmortizationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Prepaid Spend Amortization Instance and Data
 * @subpackage Structs
 */
class Prepaid_Spend_AmortizationType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Prepaid Spend Amortization
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Prepaid_Spend_Amortization_Reference;
    /**
     * The Prepaid_Spend_Amortization_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_DataType[]
     */
    public $Prepaid_Spend_Amortization_Data;
    /**
     * Constructor method for Prepaid_Spend_AmortizationType
     * @uses Prepaid_Spend_AmortizationType::setPrepaid_Spend_Amortization_Reference()
     * @uses Prepaid_Spend_AmortizationType::setPrepaid_Spend_Amortization_Data()
     * @param \StructType\Unique_IdentifierObjectType $prepaid_Spend_Amortization_Reference
     * @param \StructType\Prepaid_Spend_Amortization_DataType[] $prepaid_Spend_Amortization_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $prepaid_Spend_Amortization_Reference = null, array $prepaid_Spend_Amortization_Data = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Reference($prepaid_Spend_Amortization_Reference)
            ->setPrepaid_Spend_Amortization_Data($prepaid_Spend_Amortization_Data);
    }
    /**
     * Get Prepaid_Spend_Amortization_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getPrepaid_Spend_Amortization_Reference()
    {
        return $this->Prepaid_Spend_Amortization_Reference;
    }
    /**
     * Set Prepaid_Spend_Amortization_Reference value
     * @param \StructType\Unique_IdentifierObjectType $prepaid_Spend_Amortization_Reference
     * @return \StructType\Prepaid_Spend_AmortizationType
     */
    public function setPrepaid_Spend_Amortization_Reference(\StructType\Unique_IdentifierObjectType $prepaid_Spend_Amortization_Reference = null)
    {
        $this->Prepaid_Spend_Amortization_Reference = $prepaid_Spend_Amortization_Reference;
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Data value
     * @return \StructType\Prepaid_Spend_Amortization_DataType[]|null
     */
    public function getPrepaid_Spend_Amortization_Data()
    {
        return $this->Prepaid_Spend_Amortization_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Spend_Amortization_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Spend_Amortization_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem instanceof \StructType\Prepaid_Spend_Amortization_DataType) {
                $invalidValues[] = is_object($prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem) ? get_class($prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem) : sprintf('%s(%s)', gettype($prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem), var_export($prepaid_Spend_AmortizationTypePrepaid_Spend_Amortization_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Spend_Amortization_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_DataType[] $prepaid_Spend_Amortization_Data
     * @return \StructType\Prepaid_Spend_AmortizationType
     */
    public function setPrepaid_Spend_Amortization_Data(array $prepaid_Spend_Amortization_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Spend_Amortization_DataArrayErrorMessage = self::validatePrepaid_Spend_Amortization_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Data($prepaid_Spend_Amortization_Data))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_DataArrayErrorMessage, __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Data = $prepaid_Spend_Amortization_Data;
        return $this;
    }
    /**
     * Add item to Prepaid_Spend_Amortization_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_DataType $item
     * @return \StructType\Prepaid_Spend_AmortizationType
     */
    public function addToPrepaid_Spend_Amortization_Data(\StructType\Prepaid_Spend_Amortization_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prepaid_Spend_Amortization_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Spend_Amortization_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Data[] = $item;
        return $this;
    }
}
