<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carriers_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to add or edit carrier data.
 * @subpackage Structs
 */
class Carriers_DataType extends AbstractStructBase
{
    /**
     * The Carrier_ID
     * Meta information extracted from the WSDL
     * - documentation: Carrier ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_ID;
    /**
     * The Carrier_Name
     * Meta information extracted from the WSDL
     * - documentation: Carrier Name
     * - maxOccurs: 1
     * @var string
     */
    public $Carrier_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Carriers_DataType
     * @uses Carriers_DataType::setCarrier_ID()
     * @uses Carriers_DataType::setCarrier_Name()
     * @uses Carriers_DataType::setDescription()
     * @uses Carriers_DataType::setInactive()
     * @param string $carrier_ID
     * @param string $carrier_Name
     * @param string $description
     * @param bool $inactive
     */
    public function __construct($carrier_ID = null, $carrier_Name = null, $description = null, $inactive = null)
    {
        $this
            ->setCarrier_ID($carrier_ID)
            ->setCarrier_Name($carrier_Name)
            ->setDescription($description)
            ->setInactive($inactive);
    }
    /**
     * Get Carrier_ID value
     * @return string|null
     */
    public function getCarrier_ID()
    {
        return $this->Carrier_ID;
    }
    /**
     * Set Carrier_ID value
     * @param string $carrier_ID
     * @return \StructType\Carriers_DataType
     */
    public function setCarrier_ID($carrier_ID = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_ID) && !is_string($carrier_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_ID, true), gettype($carrier_ID)), __LINE__);
        }
        $this->Carrier_ID = $carrier_ID;
        return $this;
    }
    /**
     * Get Carrier_Name value
     * @return string|null
     */
    public function getCarrier_Name()
    {
        return $this->Carrier_Name;
    }
    /**
     * Set Carrier_Name value
     * @param string $carrier_Name
     * @return \StructType\Carriers_DataType
     */
    public function setCarrier_Name($carrier_Name = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Name) && !is_string($carrier_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Name, true), gettype($carrier_Name)), __LINE__);
        }
        $this->Carrier_Name = $carrier_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Carriers_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Carriers_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
