<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Line_Data_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents Advanced Ship Notice Line information. An Advanced Ship Notice may have multiple lines.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Line_Data_OutboundType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Advanced Ship Notice Line Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Advanced_Ship_Notice_Line_ID;
    /**
     * The Advanced_Ship_Notice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Advanced Ship Notice Line Reference
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_Notice_LineObjectType
     */
    public $Advanced_Ship_Notice_Line_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier for the Purchase or Catalog Item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Identifier;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Item linked to the Catalog or Punch-out Item.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Shipment_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment Line Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Line_Reference;
    /**
     * The Shipped_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Unit Of Measure for the Shipped Quantity. If value is not provided, it defaults to Unit of Measure from the corresponding Purchase Order line.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Shipped_Unit_of_Measure_Reference;
    /**
     * The Shipped_Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: The unit cost of the item specified in the currency associated to the Purchase Order currency. If value is not provided, defaults to unit cost of corresponding line in Purchase Order.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Shipped_Unit_Cost;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Shipped_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Shipped Quantity on Advanced Ship Notice Line.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Shipped_Quantity;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Goods line from a Purchase Order for which the Advanced Ship Notice Line is created.
     * - minOccurs: 0
     * @var \StructType\Item_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Alternate_Item_Identifier_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType[]
     */
    public $Alternate_Item_Identifier_Data;
    /**
     * The Lot_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ASN_Line_Lot_Information_Data_OutboundType[]
     */
    public $Lot_Information_Data;
    /**
     * Constructor method for Advanced_Ship_Notice_Line_Data_OutboundType
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setAdvanced_Ship_Notice_Line_ID()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setAdvanced_Ship_Notice_Line_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setItem_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setItem_Identifier()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setItem_Description()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setPurchase_Item_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setShipment_Line_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setShipped_Unit_of_Measure_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setShipped_Unit_Cost()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setConversion_Factor()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setShipped_Quantity()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setExtended_Amount()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setDeliver_To_Location_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setMemo()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setPurchase_Order_Line_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setAlternate_Item_Identifier_Data()
     * @uses Advanced_Ship_Notice_Line_Data_OutboundType::setLot_Information_Data()
     * @param string $advanced_Ship_Notice_Line_ID
     * @param \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Ship_Notice_Line_Reference
     * @param \StructType\Purchase_ItemObjectType $item_Reference
     * @param string $item_Identifier
     * @param string $item_Description
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param string $shipment_Line_Reference
     * @param \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference
     * @param float $shipped_Unit_Cost
     * @param float $conversion_Factor
     * @param float $shipped_Quantity
     * @param float $extended_Amount
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $memo
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType[] $alternate_Item_Identifier_Data
     * @param \StructType\ASN_Line_Lot_Information_Data_OutboundType[] $lot_Information_Data
     */
    public function __construct($advanced_Ship_Notice_Line_ID = null, \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Ship_Notice_Line_Reference = null, \StructType\Purchase_ItemObjectType $item_Reference = null, $item_Identifier = null, $item_Description = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, $shipment_Line_Reference = null, \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference = null, $shipped_Unit_Cost = null, $conversion_Factor = null, $shipped_Quantity = null, $extended_Amount = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $memo = null, \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null, array $alternate_Item_Identifier_Data = array(), array $lot_Information_Data = array())
    {
        $this
            ->setAdvanced_Ship_Notice_Line_ID($advanced_Ship_Notice_Line_ID)
            ->setAdvanced_Ship_Notice_Line_Reference($advanced_Ship_Notice_Line_Reference)
            ->setItem_Reference($item_Reference)
            ->setItem_Identifier($item_Identifier)
            ->setItem_Description($item_Description)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setShipment_Line_Reference($shipment_Line_Reference)
            ->setShipped_Unit_of_Measure_Reference($shipped_Unit_of_Measure_Reference)
            ->setShipped_Unit_Cost($shipped_Unit_Cost)
            ->setConversion_Factor($conversion_Factor)
            ->setShipped_Quantity($shipped_Quantity)
            ->setExtended_Amount($extended_Amount)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setMemo($memo)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data)
            ->setLot_Information_Data($lot_Information_Data);
    }
    /**
     * Get Advanced_Ship_Notice_Line_ID value
     * @return string|null
     */
    public function getAdvanced_Ship_Notice_Line_ID()
    {
        return $this->Advanced_Ship_Notice_Line_ID;
    }
    /**
     * Set Advanced_Ship_Notice_Line_ID value
     * @param string $advanced_Ship_Notice_Line_ID
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setAdvanced_Ship_Notice_Line_ID($advanced_Ship_Notice_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($advanced_Ship_Notice_Line_ID) && !is_string($advanced_Ship_Notice_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advanced_Ship_Notice_Line_ID, true), gettype($advanced_Ship_Notice_Line_ID)), __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_ID = $advanced_Ship_Notice_Line_ID;
        return $this;
    }
    /**
     * Get Advanced_Ship_Notice_Line_Reference value
     * @return \StructType\Advanced_Ship_Notice_LineObjectType|null
     */
    public function getAdvanced_Ship_Notice_Line_Reference()
    {
        return $this->Advanced_Ship_Notice_Line_Reference;
    }
    /**
     * Set Advanced_Ship_Notice_Line_Reference value
     * @param \StructType\Advanced_Ship_Notice_LineObjectType $advanced_Ship_Notice_Line_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setAdvanced_Ship_Notice_Line_Reference(\StructType\Advanced_Ship_Notice_LineObjectType $advanced_Ship_Notice_Line_Reference = null)
    {
        $this->Advanced_Ship_Notice_Line_Reference = $advanced_Ship_Notice_Line_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $item_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setItem_Reference(\StructType\Purchase_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Shipment_Line_Reference value
     * @return string|null
     */
    public function getShipment_Line_Reference()
    {
        return $this->Shipment_Line_Reference;
    }
    /**
     * Set Shipment_Line_Reference value
     * @param string $shipment_Line_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setShipment_Line_Reference($shipment_Line_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Line_Reference) && !is_string($shipment_Line_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Line_Reference, true), gettype($shipment_Line_Reference)), __LINE__);
        }
        $this->Shipment_Line_Reference = $shipment_Line_Reference;
        return $this;
    }
    /**
     * Get Shipped_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getShipped_Unit_of_Measure_Reference()
    {
        return $this->Shipped_Unit_of_Measure_Reference;
    }
    /**
     * Set Shipped_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setShipped_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference = null)
    {
        $this->Shipped_Unit_of_Measure_Reference = $shipped_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Shipped_Unit_Cost value
     * @return float|null
     */
    public function getShipped_Unit_Cost()
    {
        return $this->Shipped_Unit_Cost;
    }
    /**
     * Set Shipped_Unit_Cost value
     * @param float $shipped_Unit_Cost
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setShipped_Unit_Cost($shipped_Unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($shipped_Unit_Cost) && !(is_float($shipped_Unit_Cost) || is_numeric($shipped_Unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipped_Unit_Cost, true), gettype($shipped_Unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($shipped_Unit_Cost) && mb_strlen(mb_substr($shipped_Unit_Cost, false !== mb_strpos($shipped_Unit_Cost, '.') ? mb_strpos($shipped_Unit_Cost, '.') + 1 : mb_strlen($shipped_Unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($shipped_Unit_Cost, true), mb_strlen(mb_substr($shipped_Unit_Cost, mb_strpos($shipped_Unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($shipped_Unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $shipped_Unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($shipped_Unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $shipped_Unit_Cost))), __LINE__);
        }
        $this->Shipped_Unit_Cost = $shipped_Unit_Cost;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Shipped_Quantity value
     * @return float|null
     */
    public function getShipped_Quantity()
    {
        return $this->Shipped_Quantity;
    }
    /**
     * Set Shipped_Quantity value
     * @param float $shipped_Quantity
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setShipped_Quantity($shipped_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($shipped_Quantity) && !(is_float($shipped_Quantity) || is_numeric($shipped_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipped_Quantity, true), gettype($shipped_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($shipped_Quantity) && mb_strlen(mb_substr($shipped_Quantity, false !== mb_strpos($shipped_Quantity, '.') ? mb_strpos($shipped_Quantity, '.') + 1 : mb_strlen($shipped_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($shipped_Quantity, true), mb_strlen(mb_substr($shipped_Quantity, mb_strpos($shipped_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($shipped_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $shipped_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($shipped_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $shipped_Quantity))), __LINE__);
        }
        $this->Shipped_Quantity = $shipped_Quantity;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Item_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifier_Data value
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType[]|null
     */
    public function getAlternate_Item_Identifier_Data()
    {
        return $this->Alternate_Item_Identifier_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifier_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem) ? get_class($advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem), var_export($advanced_Ship_Notice_Line_Data_OutboundTypeAlternate_Item_Identifier_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType[] $alternate_Item_Identifier_Data
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setAlternate_Item_Identifier_Data(array $alternate_Item_Identifier_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifier_DataArrayErrorMessage = self::validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifier_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifier_Data = $alternate_Item_Identifier_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType $item
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function addToAlternate_Item_Identifier_Data(\StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifier_Data[] = $item;
        return $this;
    }
    /**
     * Get Lot_Information_Data value
     * @return \StructType\ASN_Line_Lot_Information_Data_OutboundType[]|null
     */
    public function getLot_Information_Data()
    {
        return $this->Lot_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLot_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLot_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLot_Information_DataForArrayConstraintsFromSetLot_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem instanceof \StructType\ASN_Line_Lot_Information_Data_OutboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem) ? get_class($advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem), var_export($advanced_Ship_Notice_Line_Data_OutboundTypeLot_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lot_Information_Data property can only contain items of type \StructType\ASN_Line_Lot_Information_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lot_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Line_Lot_Information_Data_OutboundType[] $lot_Information_Data
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function setLot_Information_Data(array $lot_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($lot_Information_DataArrayErrorMessage = self::validateLot_Information_DataForArrayConstraintsFromSetLot_Information_Data($lot_Information_Data))) {
            throw new \InvalidArgumentException($lot_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Lot_Information_Data = $lot_Information_Data;
        return $this;
    }
    /**
     * Add item to Lot_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Line_Lot_Information_Data_OutboundType $item
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType
     */
    public function addToLot_Information_Data(\StructType\ASN_Line_Lot_Information_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ASN_Line_Lot_Information_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Lot_Information_Data property can only contain items of type \StructType\ASN_Line_Lot_Information_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lot_Information_Data[] = $item;
        return $this;
    }
}
