<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @subpackage Services
 */
class Transfer extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Transfer_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will allow you to transfer business assets and submit them to the business process. Request data includes issue date, custodian (worker), location and worktags for the corresponding transfer transaction. A
     * boolean is provided that allows the location and worktags values to be defaulted from the custodian.This web service doesn't enable Workday to automatically populate related worktags.The public Get Asset web service may be used to export current
     * business asset information and obtain references.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Transfer_Asset_RequestRootType $body
     * @return \StructType\Transfer_Asset_ResponseType|bool
     */
    public function Transfer_Asset(\StructType\Transfer_Asset_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Transfer_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Transfer_Asset_To_Different_Company
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service enables Business Assets be transferred from one Company to another.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Transfer_Asset_To_Different_Company_RequestType $body
     * @return \StructType\Transfer_Asset_To_Different_Company_ResponseType|bool
     */
    public function Transfer_Asset_To_Different_Company(\StructType\Transfer_Asset_To_Different_Company_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Transfer_Asset_To_Different_Company($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Transfer_Asset_ResponseType|\StructType\Transfer_Asset_To_Different_Company_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
