<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Acknowledgement_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Order Acknowledgement Request References
 * @subpackage Structs
 */
class Purchase_Order_Acknowledgement_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to existing Purchase Order Acknowledgements to be retrieved via the Get Purchase Order Acknowledgement (Web Service) Web Service operation.
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_Order_AcknowledgementObjectType[]
     */
    public $Purchase_Order_Acknowledgement_Reference;
    /**
     * Constructor method for Purchase_Order_Acknowledgement_Request_ReferencesType
     * @uses Purchase_Order_Acknowledgement_Request_ReferencesType::setPurchase_Order_Acknowledgement_Reference()
     * @param \StructType\Purchase_Order_AcknowledgementObjectType[] $purchase_Order_Acknowledgement_Reference
     */
    public function __construct(array $purchase_Order_Acknowledgement_Reference = array())
    {
        $this
            ->setPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference);
    }
    /**
     * Get Purchase_Order_Acknowledgement_Reference value
     * @return \StructType\Purchase_Order_AcknowledgementObjectType[]|null
     */
    public function getPurchase_Order_Acknowledgement_Reference()
    {
        return $this->Purchase_Order_Acknowledgement_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Acknowledgement_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Acknowledgement_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Acknowledgement_ReferenceForArrayConstraintsFromSetPurchase_Order_Acknowledgement_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem instanceof \StructType\Purchase_Order_AcknowledgementObjectType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem) ? get_class($purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem), var_export($purchase_Order_Acknowledgement_Request_ReferencesTypePurchase_Order_Acknowledgement_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Acknowledgement_Reference property can only contain items of type \StructType\Purchase_Order_AcknowledgementObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_AcknowledgementObjectType[] $purchase_Order_Acknowledgement_Reference
     * @return \StructType\Purchase_Order_Acknowledgement_Request_ReferencesType
     */
    public function setPurchase_Order_Acknowledgement_Reference(array $purchase_Order_Acknowledgement_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Acknowledgement_ReferenceArrayErrorMessage = self::validatePurchase_Order_Acknowledgement_ReferenceForArrayConstraintsFromSetPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Acknowledgement_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Reference = $purchase_Order_Acknowledgement_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Acknowledgement_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $item
     * @return \StructType\Purchase_Order_Acknowledgement_Request_ReferencesType
     */
    public function addToPurchase_Order_Acknowledgement_Reference(\StructType\Purchase_Order_AcknowledgementObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_AcknowledgementObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Acknowledgement_Reference property can only contain items of type \StructType\Purchase_Order_AcknowledgementObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Reference[] = $item;
        return $this;
    }
}
