<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Unit_of_Measure_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Unit of Measure Data
 * @subpackage Structs
 */
class Purchase_Item_Unit_of_Measure_DataType extends AbstractStructBase
{
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Unit of Measure
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Price of Catalog Item starting on the Effective Date. | Item Unit Price | Unit Cost of Purchase Item for the corresponding UOM. | Unit Price. | Unit Price for Advanced Pricing Rule. The currency is the same as the supplier
     * information detail. | Unit Price for the JIT UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items. | Unit Price of the Ordering UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Price;
    /**
     * The UOM_Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Usage for the corresponding UOM.
     * - maxOccurs: unbounded
     * @var \StructType\UOM_UsageObjectType[]
     */
    public $UOM_Usage_Reference;
    /**
     * The Default_for_Ordering
     * Meta information extracted from the WSDL
     * - documentation: Default for Ordering UOM
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_for_Ordering;
    /**
     * The Default_for_Stocking
     * Meta information extracted from the WSDL
     * - documentation: Default for Stocking UOM
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_for_Stocking;
    /**
     * The Default_for_Issuing
     * Meta information extracted from the WSDL
     * - documentation: Default for Inventory Issuing UOM
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_for_Issuing;
    /**
     * The Default_for_Unit_of_Use
     * Meta information extracted from the WSDL
     * - documentation: Default for Unit of Use UOM
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_for_Unit_of_Use;
    /**
     * The Allow_Decimal_Quantities
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate whether the stocking unit of measure allows decimals.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_Decimal_Quantities;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Stocking Unit of Measure Conversion Factor Status
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Purchase_Item_Unit_of_Measure_DataType
     * @uses Purchase_Item_Unit_of_Measure_DataType::setUnit_of_Measure_Reference()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setConversion_Factor()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setUnit_Price()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setUOM_Usage_Reference()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setDefault_for_Ordering()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setDefault_for_Stocking()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setDefault_for_Issuing()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setDefault_for_Unit_of_Use()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setAllow_Decimal_Quantities()
     * @uses Purchase_Item_Unit_of_Measure_DataType::setInactive()
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $conversion_Factor
     * @param float $unit_Price
     * @param \StructType\UOM_UsageObjectType[] $uOM_Usage_Reference
     * @param bool $default_for_Ordering
     * @param bool $default_for_Stocking
     * @param bool $default_for_Issuing
     * @param bool $default_for_Unit_of_Use
     * @param bool $allow_Decimal_Quantities
     * @param bool $inactive
     */
    public function __construct(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $conversion_Factor = null, $unit_Price = null, array $uOM_Usage_Reference = array(), $default_for_Ordering = null, $default_for_Stocking = null, $default_for_Issuing = null, $default_for_Unit_of_Use = null, $allow_Decimal_Quantities = null, $inactive = null)
    {
        $this
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setConversion_Factor($conversion_Factor)
            ->setUnit_Price($unit_Price)
            ->setUOM_Usage_Reference($uOM_Usage_Reference)
            ->setDefault_for_Ordering($default_for_Ordering)
            ->setDefault_for_Stocking($default_for_Stocking)
            ->setDefault_for_Issuing($default_for_Issuing)
            ->setDefault_for_Unit_of_Use($default_for_Unit_of_Use)
            ->setAllow_Decimal_Quantities($allow_Decimal_Quantities)
            ->setInactive($inactive);
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Unit_Price value
     * @return float|null
     */
    public function getUnit_Price()
    {
        return $this->Unit_Price;
    }
    /**
     * Set Unit_Price value
     * @param float $unit_Price
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setUnit_Price($unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Price) && !(is_float($unit_Price) || is_numeric($unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Price, true), gettype($unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Price) && mb_strlen(mb_substr($unit_Price, false !== mb_strpos($unit_Price, '.') ? mb_strpos($unit_Price, '.') + 1 : mb_strlen($unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Price, true), mb_strlen(mb_substr($unit_Price, mb_strpos($unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Price))), __LINE__);
        }
        $this->Unit_Price = $unit_Price;
        return $this;
    }
    /**
     * Get UOM_Usage_Reference value
     * @return \StructType\UOM_UsageObjectType[]|null
     */
    public function getUOM_Usage_Reference()
    {
        return $this->UOM_Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setUOM_Usage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUOM_Usage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUOM_Usage_ReferenceForArrayConstraintsFromSetUOM_Usage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem instanceof \StructType\UOM_UsageObjectType) {
                $invalidValues[] = is_object($purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem) ? get_class($purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem), var_export($purchase_Item_Unit_of_Measure_DataTypeUOM_Usage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UOM_Usage_Reference property can only contain items of type \StructType\UOM_UsageObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UOM_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\UOM_UsageObjectType[] $uOM_Usage_Reference
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setUOM_Usage_Reference(array $uOM_Usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($uOM_Usage_ReferenceArrayErrorMessage = self::validateUOM_Usage_ReferenceForArrayConstraintsFromSetUOM_Usage_Reference($uOM_Usage_Reference))) {
            throw new \InvalidArgumentException($uOM_Usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->UOM_Usage_Reference = $uOM_Usage_Reference;
        return $this;
    }
    /**
     * Add item to UOM_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\UOM_UsageObjectType $item
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function addToUOM_Usage_Reference(\StructType\UOM_UsageObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UOM_UsageObjectType) {
            throw new \InvalidArgumentException(sprintf('The UOM_Usage_Reference property can only contain items of type \StructType\UOM_UsageObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UOM_Usage_Reference[] = $item;
        return $this;
    }
    /**
     * Get Default_for_Ordering value
     * @return bool|null
     */
    public function getDefault_for_Ordering()
    {
        return $this->Default_for_Ordering;
    }
    /**
     * Set Default_for_Ordering value
     * @param bool $default_for_Ordering
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setDefault_for_Ordering($default_for_Ordering = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_for_Ordering) && !is_bool($default_for_Ordering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_for_Ordering, true), gettype($default_for_Ordering)), __LINE__);
        }
        $this->Default_for_Ordering = $default_for_Ordering;
        return $this;
    }
    /**
     * Get Default_for_Stocking value
     * @return bool|null
     */
    public function getDefault_for_Stocking()
    {
        return $this->Default_for_Stocking;
    }
    /**
     * Set Default_for_Stocking value
     * @param bool $default_for_Stocking
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setDefault_for_Stocking($default_for_Stocking = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_for_Stocking) && !is_bool($default_for_Stocking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_for_Stocking, true), gettype($default_for_Stocking)), __LINE__);
        }
        $this->Default_for_Stocking = $default_for_Stocking;
        return $this;
    }
    /**
     * Get Default_for_Issuing value
     * @return bool|null
     */
    public function getDefault_for_Issuing()
    {
        return $this->Default_for_Issuing;
    }
    /**
     * Set Default_for_Issuing value
     * @param bool $default_for_Issuing
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setDefault_for_Issuing($default_for_Issuing = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_for_Issuing) && !is_bool($default_for_Issuing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_for_Issuing, true), gettype($default_for_Issuing)), __LINE__);
        }
        $this->Default_for_Issuing = $default_for_Issuing;
        return $this;
    }
    /**
     * Get Default_for_Unit_of_Use value
     * @return bool|null
     */
    public function getDefault_for_Unit_of_Use()
    {
        return $this->Default_for_Unit_of_Use;
    }
    /**
     * Set Default_for_Unit_of_Use value
     * @param bool $default_for_Unit_of_Use
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setDefault_for_Unit_of_Use($default_for_Unit_of_Use = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_for_Unit_of_Use) && !is_bool($default_for_Unit_of_Use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_for_Unit_of_Use, true), gettype($default_for_Unit_of_Use)), __LINE__);
        }
        $this->Default_for_Unit_of_Use = $default_for_Unit_of_Use;
        return $this;
    }
    /**
     * Get Allow_Decimal_Quantities value
     * @return bool|null
     */
    public function getAllow_Decimal_Quantities()
    {
        return $this->Allow_Decimal_Quantities;
    }
    /**
     * Set Allow_Decimal_Quantities value
     * @param bool $allow_Decimal_Quantities
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setAllow_Decimal_Quantities($allow_Decimal_Quantities = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_Decimal_Quantities) && !is_bool($allow_Decimal_Quantities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_Decimal_Quantities, true), gettype($allow_Decimal_Quantities)), __LINE__);
        }
        $this->Allow_Decimal_Quantities = $allow_Decimal_Quantities;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Purchase_Item_Unit_of_Measure_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
