<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Rate_Table__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't set an Attribute to Multiply value on Maximum and Graduated Percent rate tables. | Currency is required for Expense Rate Table with table type of Amount, Graduated Amount, or Maximum Amount. Currency is not used in Expense
 * Rate Table with table type of Graduated Percent. | Element containing all Expense Rate Table data
 * @subpackage Structs
 */
class Expense_Rate_Table__HV__DataType extends AbstractStructBase
{
    /**
     * The Expense_Rate_Table_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Rate Table ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Rate_Table_ID;
    /**
     * The Expense_Rate_Table_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text for a meaningful Expense Rate Table Name
     * - maxOccurs: 1
     * @var string
     */
    public $Expense_Rate_Table_Name;
    /**
     * The Expense_Rate_Table_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table Type. This will determine the usage of the expense rate table, as well as how it is evaluated on the calculation of the fixed/maximum amount of an expense item
     * @var \StructType\Expense_Rate_Table_TypeObjectType
     */
    public $Expense_Rate_Table_Type_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Expense_Item_Attribute_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Item Attribute Type. The expense item attribute will be evaluated by the range of a graduated expense rate and/or is a variable in the calculation of the fixed amount of an expense item
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Attribute_TypeObjectType
     */
    public $Expense_Item_Attribute_Type_Reference;
    /**
     * The Expense_Item_Attribute_to_Multiply_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sets which attribute type will be used to multiply for Expense Rate Table calculations.
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Attribute_TypeObjectType
     */
    public $Expense_Item_Attribute_to_Multiply_Reference;
    /**
     * The Expense_Rate_Table_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date
     * - maxOccurs: 1
     * @var string
     */
    public $Expense_Rate_Table_Effective_Date;
    /**
     * The Expense_Rate_Table_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Rate_Table_Line__HV__DataType[]
     */
    public $Expense_Rate_Table_Line_Replacement_Data;
    /**
     * Constructor method for Expense_Rate_Table__HV__DataType
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Rate_Table_ID()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Rate_Table_Name()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Rate_Table_Type_Reference()
     * @uses Expense_Rate_Table__HV__DataType::setCurrency_Reference()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Item_Attribute_Type_Reference()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Item_Attribute_to_Multiply_Reference()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Rate_Table_Effective_Date()
     * @uses Expense_Rate_Table__HV__DataType::setExpense_Rate_Table_Line_Replacement_Data()
     * @param string $expense_Rate_Table_ID
     * @param string $expense_Rate_Table_Name
     * @param \StructType\Expense_Rate_Table_TypeObjectType $expense_Rate_Table_Type_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_to_Multiply_Reference
     * @param string $expense_Rate_Table_Effective_Date
     * @param \StructType\Expense_Rate_Table_Line__HV__DataType[] $expense_Rate_Table_Line_Replacement_Data
     */
    public function __construct($expense_Rate_Table_ID = null, $expense_Rate_Table_Name = null, \StructType\Expense_Rate_Table_TypeObjectType $expense_Rate_Table_Type_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference = null, \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_to_Multiply_Reference = null, $expense_Rate_Table_Effective_Date = null, array $expense_Rate_Table_Line_Replacement_Data = array())
    {
        $this
            ->setExpense_Rate_Table_ID($expense_Rate_Table_ID)
            ->setExpense_Rate_Table_Name($expense_Rate_Table_Name)
            ->setExpense_Rate_Table_Type_Reference($expense_Rate_Table_Type_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setExpense_Item_Attribute_Type_Reference($expense_Item_Attribute_Type_Reference)
            ->setExpense_Item_Attribute_to_Multiply_Reference($expense_Item_Attribute_to_Multiply_Reference)
            ->setExpense_Rate_Table_Effective_Date($expense_Rate_Table_Effective_Date)
            ->setExpense_Rate_Table_Line_Replacement_Data($expense_Rate_Table_Line_Replacement_Data);
    }
    /**
     * Get Expense_Rate_Table_ID value
     * @return string|null
     */
    public function getExpense_Rate_Table_ID()
    {
        return $this->Expense_Rate_Table_ID;
    }
    /**
     * Set Expense_Rate_Table_ID value
     * @param string $expense_Rate_Table_ID
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Rate_Table_ID($expense_Rate_Table_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Rate_Table_ID) && !is_string($expense_Rate_Table_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Rate_Table_ID, true), gettype($expense_Rate_Table_ID)), __LINE__);
        }
        $this->Expense_Rate_Table_ID = $expense_Rate_Table_ID;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Name value
     * @return string|null
     */
    public function getExpense_Rate_Table_Name()
    {
        return $this->Expense_Rate_Table_Name;
    }
    /**
     * Set Expense_Rate_Table_Name value
     * @param string $expense_Rate_Table_Name
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Rate_Table_Name($expense_Rate_Table_Name = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Rate_Table_Name) && !is_string($expense_Rate_Table_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Rate_Table_Name, true), gettype($expense_Rate_Table_Name)), __LINE__);
        }
        $this->Expense_Rate_Table_Name = $expense_Rate_Table_Name;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Type_Reference value
     * @return \StructType\Expense_Rate_Table_TypeObjectType|null
     */
    public function getExpense_Rate_Table_Type_Reference()
    {
        return $this->Expense_Rate_Table_Type_Reference;
    }
    /**
     * Set Expense_Rate_Table_Type_Reference value
     * @param \StructType\Expense_Rate_Table_TypeObjectType $expense_Rate_Table_Type_Reference
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Rate_Table_Type_Reference(\StructType\Expense_Rate_Table_TypeObjectType $expense_Rate_Table_Type_Reference = null)
    {
        $this->Expense_Rate_Table_Type_Reference = $expense_Rate_Table_Type_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Attribute_Type_Reference value
     * @return \StructType\Expense_Item_Attribute_TypeObjectType|null
     */
    public function getExpense_Item_Attribute_Type_Reference()
    {
        return $this->Expense_Item_Attribute_Type_Reference;
    }
    /**
     * Set Expense_Item_Attribute_Type_Reference value
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Item_Attribute_Type_Reference(\StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_Type_Reference = null)
    {
        $this->Expense_Item_Attribute_Type_Reference = $expense_Item_Attribute_Type_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Attribute_to_Multiply_Reference value
     * @return \StructType\Expense_Item_Attribute_TypeObjectType|null
     */
    public function getExpense_Item_Attribute_to_Multiply_Reference()
    {
        return $this->Expense_Item_Attribute_to_Multiply_Reference;
    }
    /**
     * Set Expense_Item_Attribute_to_Multiply_Reference value
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_to_Multiply_Reference
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Item_Attribute_to_Multiply_Reference(\StructType\Expense_Item_Attribute_TypeObjectType $expense_Item_Attribute_to_Multiply_Reference = null)
    {
        $this->Expense_Item_Attribute_to_Multiply_Reference = $expense_Item_Attribute_to_Multiply_Reference;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Effective_Date value
     * @return string|null
     */
    public function getExpense_Rate_Table_Effective_Date()
    {
        return $this->Expense_Rate_Table_Effective_Date;
    }
    /**
     * Set Expense_Rate_Table_Effective_Date value
     * @param string $expense_Rate_Table_Effective_Date
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Rate_Table_Effective_Date($expense_Rate_Table_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Rate_Table_Effective_Date) && !is_string($expense_Rate_Table_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Rate_Table_Effective_Date, true), gettype($expense_Rate_Table_Effective_Date)), __LINE__);
        }
        $this->Expense_Rate_Table_Effective_Date = $expense_Rate_Table_Effective_Date;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Line_Replacement_Data value
     * @return \StructType\Expense_Rate_Table_Line__HV__DataType[]|null
     */
    public function getExpense_Rate_Table_Line_Replacement_Data()
    {
        return $this->Expense_Rate_Table_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Rate_Table_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Rate_Table_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Rate_Table_Line_Replacement_DataForArrayConstraintsFromSetExpense_Rate_Table_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem instanceof \StructType\Expense_Rate_Table_Line__HV__DataType) {
                $invalidValues[] = is_object($expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem) ? get_class($expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem), var_export($expense_Rate_Table_HV_DataTypeExpense_Rate_Table_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Rate_Table_Line_Replacement_Data property can only contain items of type \StructType\Expense_Rate_Table_Line__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Rate_Table_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Rate_Table_Line__HV__DataType[] $expense_Rate_Table_Line_Replacement_Data
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function setExpense_Rate_Table_Line_Replacement_Data(array $expense_Rate_Table_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Rate_Table_Line_Replacement_DataArrayErrorMessage = self::validateExpense_Rate_Table_Line_Replacement_DataForArrayConstraintsFromSetExpense_Rate_Table_Line_Replacement_Data($expense_Rate_Table_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($expense_Rate_Table_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Rate_Table_Line_Replacement_Data = $expense_Rate_Table_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Expense_Rate_Table_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Rate_Table_Line__HV__DataType $item
     * @return \StructType\Expense_Rate_Table__HV__DataType
     */
    public function addToExpense_Rate_Table_Line_Replacement_Data(\StructType\Expense_Rate_Table_Line__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Rate_Table_Line__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Rate_Table_Line_Replacement_Data property can only contain items of type \StructType\Expense_Rate_Table_Line__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Rate_Table_Line_Replacement_Data[] = $item;
        return $this;
    }
}
